/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.junit4.JUnit4ReflectionUtil;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestListener
extends RunListener {
    public static final String EMPTY_SUITE_NAME = "junit.framework.TestSuite$1";
    public static final String EMPTY_SUITE_WARNING = "warning";
    public static final String CLASS_CONFIGURATION = "Class Configuration";
    private List myStartedSuites = new ArrayList();
    private Map myParents = new HashMap();
    private Map myMethodNames = new HashMap();
    private final PrintStream myPrintStream;
    private String myRootName;
    private long myCurrentTestStart;
    private int myFinishedCount = 0;
    private Description myCurrentTest;
    private Map myWaitingQueue = new LinkedHashMap();
    static /* synthetic */ Class class$org$junit$Ignore;

    public JUnit4TestListener() {
        this(System.out);
    }

    public JUnit4TestListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.STD_ESCAPER);
    }

    public void testRunStarted(Description description) throws Exception {
        if (this.myRootName != null && !this.myRootName.startsWith("[")) {
            int lastPointIdx = this.myRootName.lastIndexOf(46);
            String name = this.myRootName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = this.myRootName.substring(lastPointIdx + 1);
                comment = this.myRootName.substring(0, lastPointIdx);
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit4TestListener.escapeName(name) + (comment != null ? "' comment = '" + JUnit4TestListener.escapeName(comment) : "") + "'" + " location = 'java:suite://" + JUnit4TestListener.escapeName(this.myRootName) + "']");
            this.myRootName = JUnit4TestListener.getShortName(this.myRootName);
        }
    }

    public void testRunFinished(Result result) {
        this.dumpQueue(true);
        for (int i = this.myStartedSuites.size() - 1; i >= 0; --i) {
            String parent = JUnit4ReflectionUtil.getClassName((Description)this.myStartedSuites.get(i));
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(parent)) + "']");
        }
        this.myStartedSuites.clear();
    }

    public void testStarted(Description description) {
        this.testStarted(description, null);
    }

    private void testStarted(Description description, String methodName) {
        int i;
        Description currentParent;
        Description currentClass;
        int idx;
        List parentsHierarchy;
        List parents = (List)this.myParents.get(description);
        if (this.myCurrentTest != null && (parents == null || parents.isEmpty() || !((List)parents.get(0)).contains(this.myCurrentTest))) {
            this.myWaitingQueue.put(description, new TestEvent());
            return;
        }
        this.myCurrentTest = description;
        String classFQN = JUnit4ReflectionUtil.getClassName(description);
        List list = parentsHierarchy = parents != null && !parents.isEmpty() ? (List)parents.remove(0) : Collections.singletonList(Description.createSuiteDescription((String)classFQN, (Annotation[])new Annotation[0]));
        if (methodName == null && (methodName = this.getFullMethodName(description, parentsHierarchy.isEmpty() ? null : (Description)parentsHierarchy.get(parentsHierarchy.size() - 1))) == null) {
            return;
        }
        for (idx = 0; idx < this.myStartedSuites.size() && idx < parentsHierarchy.size() && !JUnit4TestListener.isHierarchyDifferent(parents, currentClass = (Description)this.myStartedSuites.get(idx), currentParent = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - idx)); ++idx) {
        }
        for (i = this.myStartedSuites.size() - 1; i >= idx; --i) {
            currentClass = (Description)this.myStartedSuites.remove(i);
            this.myFinishedCount = 0;
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(currentClass))) + "']");
        }
        for (i = idx; i < parentsHierarchy.size(); ++i) {
            Description descriptionFromHistory = (Description)parentsHierarchy.get(parentsHierarchy.size() - 1 - i);
            String fqName = JUnit4ReflectionUtil.getClassName(descriptionFromHistory);
            String className = JUnit4TestListener.getShortName(fqName);
            if (className.equals(this.myRootName)) continue;
            this.myPrintStream.println("##teamcity[testSuiteStarted name='" + JUnit4TestListener.escapeName(className) + "'" + (parents == null ? JUnit4TestListener.getClassLocation(fqName) : "") + "]");
            this.myStartedSuites.add(descriptionFromHistory);
        }
        this.myPrintStream.println("\n##teamcity[testStarted name='" + JUnit4TestListener.escapeName(methodName) + "' " + JUnit4TestListener.getTestMethodLocation(methodName, classFQN) + "]");
        this.myCurrentTestStart = this.currentTime();
    }

    private static String getClassLocation(String fqName) {
        return " locationHint='java:suite://" + JUnit4TestListener.escapeName(fqName) + "'";
    }

    private static boolean isHierarchyDifferent(List parents, Description currentClass, Description currentParent) {
        if (parents == null) {
            return !currentClass.equals((Object)currentParent);
        }
        return System.identityHashCode(currentClass) != System.identityHashCode(currentParent);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    public void testFinished(Description description) {
        if (this.startedInParallel(description)) {
            TestEvent testEvent = (TestEvent)this.myWaitingQueue.get(description);
            testEvent.setFinished(true);
            return;
        }
        this.testFinishedNoDumping(this.getFullMethodName(description));
        this.dumpQueue(false);
    }

    private boolean startedInParallel(Description description) {
        return this.myWaitingQueue.containsKey(description) && (this.myCurrentTest == null || !this.myCurrentTest.equals((Object)description));
    }

    private void testFinishedNoDumping(String methodName) {
        if (methodName != null) {
            ++this.myFinishedCount;
            long duration = this.currentTime() - this.myCurrentTestStart;
            this.myPrintStream.println("\n##teamcity[testFinished name='" + JUnit4TestListener.escapeName(methodName) + (duration > 0L ? "' duration='" + Long.toString(duration) : "") + "']");
        }
        this.myCurrentTest = null;
    }

    public void testFailure(Failure failure) {
        this.testFailure(failure, failure.getDescription(), "testFailed");
    }

    private void testFailure(Failure failure, Description description, String messageName) {
        boolean isIgnored = "testIgnored".equals(messageName);
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            if (!isIgnored) {
                this.classConfigurationStarted(description);
                this.testFailure(failure, description, messageName, CLASS_CONFIGURATION);
                this.classConfigurationFinished(description);
            }
            if (this.myFinishedCount == 0) {
                Iterator iterator = ((AbstractList)description.getChildren()).iterator();
                while (iterator.hasNext()) {
                    Description next = (Description)iterator.next();
                    this.testStarted(next);
                    this.testFailure((Failure)(isIgnored ? failure : null), next, "testIgnored");
                    this.testFinished(next);
                }
            }
        } else {
            this.testFailure(failure, description, messageName, methodName);
        }
    }

    private void classConfigurationFinished(Description description) {
        if (this.startedInParallel(description)) {
            TestEvent testEvent = (TestEvent)this.myWaitingQueue.get(description);
            testEvent.setFinished(true);
            return;
        }
        this.myPrintStream.println("\n##teamcity[testFinished name='" + JUnit4TestListener.escapeName(CLASS_CONFIGURATION) + "']");
        this.myCurrentTest = null;
    }

    private void classConfigurationStarted(Description description) {
        if (this.myCurrentTest != null) {
            TestEvent value = new TestEvent();
            value.setMethodName(CLASS_CONFIGURATION);
            this.myWaitingQueue.put(description, value);
            return;
        }
        this.myCurrentTest = description;
        this.myPrintStream.println("##teamcity[testStarted name='" + JUnit4TestListener.escapeName(CLASS_CONFIGURATION) + "' " + JUnit4TestListener.getClassLocation(JUnit4ReflectionUtil.getClassName(description)) + " ]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(Failure failure, Description description, String messageName, String methodName) {
        boolean isIgnored = "testIgnored".equals(messageName);
        if (this.startedInParallel(description)) {
            TestEvent testEvent = (TestEvent)this.myWaitingQueue.get(description);
            if (testEvent == null) {
                testEvent = new TestEvent();
                this.myWaitingQueue.put(description, testEvent);
            }
            testEvent.setIgnored(isIgnored);
            testEvent.setFailure(failure);
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", methodName);
        long duration = this.currentTime() - this.myCurrentTestStart;
        if (duration > 0L) {
            attrs.put("duration", Long.toString(duration));
        }
        try {
            if (failure != null) {
                String trace = this.getTrace(failure);
                Throwable ex = failure.getException();
                ComparisonFailureData notification = ExpectedPatterns.createExceptionNotification(ex);
                ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)trace, (String)failure.getMessage(), attrs, (Throwable)ex);
            }
        }
        catch (Throwable e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            e.printStackTrace(writer);
            ComparisonFailureData.registerSMAttributes(null, (String)stringWriter.toString(), (String)e.getMessage(), attrs, (Throwable)e);
        }
        finally {
            this.myPrintStream.println("\n" + MapSerializerUtil.asString(messageName, attrs));
        }
    }

    protected String getTrace(Failure failure) {
        return failure.getTrace();
    }

    public void testAssumptionFailure(Failure failure) {
        this.testFailure(failure, failure.getDescription(), "testIgnored");
    }

    private String getFullMethodName(Description description) {
        return this.getFullMethodName(description, null);
    }

    private String getFullMethodName(Description description, Description parent) {
        String methodName = (String)this.myMethodNames.get(description);
        if (methodName == null) {
            methodName = JUnit4ReflectionUtil.getMethodName(description);
            if (!(methodName == null || parent != null && JUnit4TestListener.isParameter(parent))) {
                methodName = JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description)) + "." + methodName;
            }
            if (methodName == null && description.getChildren().isEmpty()) {
                methodName = JUnit4TestListener.getShortName(description.getDisplayName());
            }
            this.myMethodNames.put(description, methodName);
        }
        return methodName;
    }

    public void testIgnored(Description description) {
        String methodName = this.getFullMethodName(description);
        if (methodName == null) {
            Iterator iterator = ((AbstractList)description.getChildren()).iterator();
            while (iterator.hasNext()) {
                Description testDescription = (Description)iterator.next();
                this.testIgnored(testDescription, this.getFullMethodName(testDescription));
            }
        } else {
            this.testIgnored(description, methodName);
        }
    }

    private void testIgnored(Description description, String methodName) {
        this.testStarted(description);
        HashMap<String, String> attrs = new HashMap<String, String>();
        try {
            String val;
            Ignore ignoredAnnotation = (Ignore)description.getAnnotation(class$org$junit$Ignore == null ? (class$org$junit$Ignore = JUnit4TestListener.class$("org.junit.Ignore")) : class$org$junit$Ignore);
            if (ignoredAnnotation != null && (val = ignoredAnnotation.value()) != null) {
                attrs.put("message", val);
            }
        }
        catch (NoSuchMethodError ignoredAnnotation) {
            // empty catch block
        }
        attrs.put("name", methodName);
        if (this.startedInParallel(description)) {
            TestEvent testEvent = (TestEvent)this.myWaitingQueue.get(description);
            if (testEvent == null) {
                testEvent = new TestEvent();
                this.myWaitingQueue.put(description, testEvent);
            }
            testEvent.setIgnored(true);
            testEvent.setAttrs(attrs);
        } else {
            this.myPrintStream.println(MapSerializerUtil.asString("testIgnored", attrs));
        }
        this.testFinished(description);
    }

    private void dumpQueue(boolean acceptUnfinished) {
        Iterator iterator = this.myWaitingQueue.keySet().iterator();
        while (iterator.hasNext()) {
            Description description = (Description)iterator.next();
            TestEvent testEvent = (TestEvent)this.myWaitingQueue.get(description);
            if (!acceptUnfinished && !testEvent.isFinished()) continue;
            iterator.remove();
            this.testStarted(description, testEvent.getMethodName());
            Failure failure = testEvent.getFailure();
            if (testEvent.isIgnored()) {
                Map attrs = testEvent.getAttrs();
                if (attrs == null) {
                    this.testFailure(failure, description, "testIgnored");
                } else {
                    this.myPrintStream.println(MapSerializerUtil.asString("testIgnored", attrs));
                }
            } else if (failure != null) {
                this.testFailure(failure);
            }
            String methodName = testEvent.getMethodName();
            this.testFinishedNoDumping(methodName != null ? methodName : this.getFullMethodName(description));
        }
    }

    private void sendTree(Description description, Description parent, List currentParents) {
        ArrayList parents;
        String parentClassName;
        ArrayList<Description> pParents = new ArrayList<Description>(3);
        pParents.addAll(currentParents);
        if (parent != null && !this.myRootName.equals(parentClassName = JUnit4ReflectionUtil.getClassName(parent))) {
            pParents.add(0, parent);
        }
        if ((parents = (ArrayList)this.myParents.get(description)) == null) {
            parents = new ArrayList(1);
            this.myParents.put(description, parents);
        }
        parents.add(pParents);
        String className = JUnit4ReflectionUtil.getClassName(description);
        if (description.isTest()) {
            String methodName = this.getFullMethodName(description, parent);
            if (methodName != null) {
                if (JUnit4TestListener.isWarning(methodName, className) && parent != null) {
                    className = JUnit4ReflectionUtil.getClassName(parent);
                }
                this.myPrintStream.println("##teamcity[suiteTreeNode name='" + JUnit4TestListener.escapeName(methodName) + "' " + JUnit4TestListener.getTestMethodLocation(methodName, className) + "]");
            }
            return;
        }
        ArrayList tests = description.getChildren();
        boolean pass = false;
        Iterator iterator = tests.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            Description nextDescription = (Description)next;
            if (!(this.myRootName != null && this.myRootName.equals(className) || pass)) {
                String displayName;
                int paramIdx;
                pass = true;
                String locationHint = className;
                if (JUnit4TestListener.isParameter(description) && (paramIdx = (displayName = nextDescription.getDisplayName()).indexOf(locationHint)) > -1 && (locationHint = displayName.substring(paramIdx + locationHint.length())).startsWith("(") && locationHint.endsWith(")")) {
                    locationHint = locationHint.substring(1, locationHint.length() - 1) + "." + className;
                }
                this.myPrintStream.println("##teamcity[suiteTreeStarted name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(className)) + "' locationHint='java:suite://" + JUnit4TestListener.escapeName(locationHint) + "']");
            }
            this.sendTree(nextDescription, description, pParents);
        }
        if (pass) {
            this.myPrintStream.println("##teamcity[suiteTreeEnded name='" + JUnit4TestListener.escapeName(JUnit4TestListener.getShortName(JUnit4ReflectionUtil.getClassName(description))) + "']");
        }
    }

    private static boolean isWarning(String methodName, String className) {
        return EMPTY_SUITE_WARNING.equals(methodName) && EMPTY_SUITE_NAME.equals(className);
    }

    private static String getTestMethodLocation(String methodName, String className) {
        return "locationHint='java:test://" + JUnit4TestListener.escapeName(className + "." + JUnit4TestListener.getShortName(methodName)) + "'";
    }

    private static boolean isParameter(Description description) {
        String displayName = description.getDisplayName();
        return displayName.startsWith("[") && displayName.endsWith("]");
    }

    public void sendTree(Description description) {
        this.myRootName = JUnit4ReflectionUtil.getClassName(description);
        this.sendTree(description, null, new ArrayList());
        this.myPrintStream.println("##teamcity[treeEnded]");
    }

    private static String getShortName(String fqName) {
        if (fqName == null) {
            return null;
        }
        int idx = fqName.indexOf("[");
        if (idx == 0) {
            return fqName;
        }
        int lastPointIdx = fqName.lastIndexOf(46);
        if (idx > 0 && fqName.endsWith("]")) {
            lastPointIdx = fqName.substring(0, idx).lastIndexOf(46);
        }
        if (lastPointIdx >= 0) {
            return fqName.substring(lastPointIdx + 1);
        }
        return fqName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TestEvent {
        private Failure myFailure;
        private boolean myIgnored;
        private boolean myFinished;
        private Map myAttrs;
        private String myMethodName;

        private TestEvent() {
        }

        public Failure getFailure() {
            return this.myFailure;
        }

        public boolean isIgnored() {
            return this.myIgnored;
        }

        public boolean isFinished() {
            return this.myFinished;
        }

        public void setFinished(boolean finished) {
            this.myFinished = finished;
        }

        public void setFailure(Failure failure) {
            this.myFailure = failure;
        }

        public void setIgnored(boolean ignored) {
            this.myIgnored = ignored;
        }

        public void setAttrs(Map attrs) {
            this.myAttrs = attrs;
        }

        public Map getAttrs() {
            return this.myAttrs;
        }

        public void setMethodName(String methodName) {
            this.myMethodName = methodName;
        }

        public String getMethodName() {
            return this.myMethodName;
        }
    }
}

