/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseGenerator {
    protected final TemplateProcessor myTemplateFactory;
    protected final LocalGeneratorPaths myPaths;

    public BaseGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths) {
        if (templateFactory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/BaseGenerator.<init> must not be null");
        }
        if (paths == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/BaseGenerator.<init> must not be null");
        }
        this.myPaths = paths;
        this.myTemplateFactory = templateFactory;
    }

    private boolean isCovered(CoverageStatistics stat) {
        return !this.isEmpty(stat.getLineStats()) || !this.isEmpty(stat.getStatementStats());
    }

    private boolean isEmpty(Entry entry) {
        return entry == null || entry.getTotal() <= 0 || entry.getCovered() < 0;
    }

    @NotNull
    protected Collection<SortOption> getGenerateSortOptions(@NotNull StatisticsCalculator covStatsCalculator) {
        if (covStatsCalculator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/BaseGenerator.getGenerateSortOptions must not be null");
        }
        ArrayList<SortOption> sortOptions = new ArrayList<SortOption>(Arrays.asList(SortOption.values()));
        sortOptions.remove((Object)SortOption.NONE);
        if (this.isEmpty(covStatsCalculator.getOverallStats().getLineStats())) {
            sortOptions.remove((Object)SortOption.SORT_BY_LINE);
            sortOptions.remove((Object)SortOption.SORT_BY_LINE_DESC);
        }
        if (this.isEmpty(covStatsCalculator.getOverallStats().getStatementStats())) {
            sortOptions.remove((Object)SortOption.SORT_BY_STATEMENT);
            sortOptions.remove((Object)SortOption.SORT_BY_STATEMENT_DESC);
        }
        ArrayList<SortOption> arrayList = sortOptions;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/BaseGenerator.getGenerateSortOptions must not return null");
        }
        return arrayList;
    }

    @NotNull
    protected <T> List<T> filterCovered(@NotNull Collection<T> collection, @NotNull Converter<T> conv) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/html/BaseGenerator.filterCovered must not be null");
        }
        if (conv == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of jetbrains/coverage/report/impl/html/BaseGenerator.filterCovered must not be null");
        }
        ArrayList<T> list = new ArrayList<T>(collection.size());
        for (T t : collection) {
            if (!this.isCovered(conv.convert(t))) continue;
            list.add(t);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method jetbrains/coverage/report/impl/html/BaseGenerator.filterCovered must not return null");
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Converter<T> {
        @NotNull
        public CoverageStatistics convert(T var1);
    }
}

