/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import java.util.ArrayList;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PrepareToDeployAction;
import org.jetbrains.idea.devkit.module.PluginModuleType;

public class PrepareAllToDeployAction
extends PrepareToDeployAction {
    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ArrayList<Module> pluginModules = new ArrayList<Module>();
        for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
            if (!PluginModuleType.isOfType(aModule)) continue;
            pluginModules.add(aModule);
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, pluginModules, DevKitBundle.message("select.plugin.modules.title", new Object[0]), DevKitBundle.message("select.plugin.modules.description", new Object[0]));
        if (dialog.showAndGet()) {
            this.doPrepare(dialog.getChosenElements(), project);
        }
    }

    @Override
    public void update(AnActionEvent e) {
        Module module;
        int moduleCount = 0;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null) {
            for (Module aModule : ModuleManager.getInstance((Project)project).getModules()) {
                if (!PluginModuleType.isOfType(aModule)) continue;
                ++moduleCount;
            }
        }
        boolean enabled = false;
        if (moduleCount > 1) {
            enabled = true;
        } else if (!(moduleCount <= 0 || (module = (Module)e.getData(LangDataKeys.MODULE)) != null && PluginModuleType.isOfType(module))) {
            enabled = true;
        }
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        if (enabled) {
            e.getPresentation().setText(DevKitBundle.message("prepare.for.deployment.all", new Object[0]));
        }
    }
}

