/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.io.File;
import javax.swing.JComponent;
import org.jetbrains.idea.devkit.dom.generator.DTDModelLoader;
import org.jetbrains.idea.devkit.dom.generator.DomGenPanel;
import org.jetbrains.idea.devkit.dom.generator.JetBrainsEmitter;
import org.jetbrains.idea.devkit.dom.generator.MergingFileManager;
import org.jetbrains.idea.devkit.dom.generator.ModelGen;
import org.jetbrains.idea.devkit.dom.generator.ModelLoader;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.XSDModelLoader;

public class DomGenDialog
extends DialogWrapper {
    final DomGenPanel panel;
    final JComponent comp;

    protected DomGenDialog(Project project) {
        super(project);
        this.panel = new DomGenPanel(project);
        this.comp = this.panel.getComponent();
        this.panel.restore();
        this.setTitle("Generate DOM Model From XSD or DTD");
        this.init();
        this.getOKAction().putValue("Name", "Generate");
    }

    protected JComponent createCenterPanel() {
        return this.comp;
    }

    protected void doOKAction() {
        if (!this.panel.validate()) {
            return;
        }
        String location = this.panel.getLocation();
        ModelLoader loader = location.toLowerCase().endsWith(".xsd") ? new XSDModelLoader() : new DTDModelLoader();
        JetBrainsEmitter emitter = new JetBrainsEmitter();
        MergingFileManager fileManager = new MergingFileManager();
        if (this.panel.getAuthor().trim().length() > 0) {
            emitter.setAuthor(this.panel.getAuthor());
        }
        if (this.panel.isUseQualifiedClassNames()) {
            emitter.enableQualifiedClassNames();
        }
        ModelGen modelGen = new ModelGen(loader, emitter, fileManager);
        NamespaceDesc desc = this.panel.getNamespaceDescriptor();
        modelGen.setConfig(desc.name, location, desc, this.panel.getSkippedSchemas());
        try {
            File output = new File(this.panel.getOutputDir());
            modelGen.perform(output, new File(location).getParentFile());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.panel.saveAll();
        super.doOKAction();
    }

    public void doCancelAction() {
        this.panel.saveAll();
        super.doCancelAction();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

