/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.impl.PropertyKeyReferenceProvider;

public class I18nReferenceContributor
extends PsiReferenceContributor {
    private static final String[] EXTENSION_TAG_NAMES = new String[]{"localInspection", "globalInspection", "configurable", "applicationConfigurable", "projectConfigurable"};
    private static final String[] TYPE_NAME_TAG = new String[]{"typeName"};
    private static final String INTENTION_ACTION_TAG = "intentionAction";
    private static final String INTENTION_ACTION_BUNDLE_TAG = "bundleName";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor", "registerReferenceProviders"));
        }
        I18nReferenceContributor.registerKeyProviders(registrar);
        I18nReferenceContributor.registerBundleNameProviders(registrar);
    }

    private static void registerKeyProviders(PsiReferenceRegistrar registrar) {
        ElementPattern pattern = I18nReferenceContributor.createPattern(EXTENSION_TAG_NAMES, "key", "groupKey");
        registrar.registerReferenceProvider(pattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "groupKey", "groupBundle"), 0.0);
        ElementPattern typeNameKeyPattern = I18nReferenceContributor.createPattern(TYPE_NAME_TAG, "resourceKey");
        registrar.registerReferenceProvider(typeNameKeyPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(false, "resourceKey", "resourceBundle"), 0.0);
        XmlTagPattern.Capture intentionActionKeyTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("categoryKey")).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_TAG)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
        registrar.registerReferenceProvider((ElementPattern)intentionActionKeyTagPattern, (PsiReferenceProvider)new PropertyKeyReferenceProvider(true, null, INTENTION_ACTION_BUNDLE_TAG));
    }

    private static void registerBundleNameProviders(PsiReferenceRegistrar registrar) {
        PsiReferenceProvider bundleReferenceProvider = new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyResourceBundleReference(element)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$1", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        };
        XmlTagPattern.Capture resourceBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName("resource-bundle")).withParent((ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin"));
        registrar.registerReferenceProvider((ElementPattern)resourceBundleTagPattern, bundleReferenceProvider);
        ElementPattern bundlePattern = I18nReferenceContributor.createPattern(EXTENSION_TAG_NAMES, "bundle", "groupBundle");
        registrar.registerReferenceProvider(bundlePattern, bundleReferenceProvider, 0.0);
        ElementPattern typeNameBundlePattern = I18nReferenceContributor.createPattern(TYPE_NAME_TAG, "resourceBundle");
        registrar.registerReferenceProvider(typeNameBundlePattern, bundleReferenceProvider, 0.0);
        XmlTagPattern.Capture intentionActionBundleTagPattern = (XmlTagPattern.Capture)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_BUNDLE_TAG)).withParent((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(INTENTION_ACTION_TAG)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
        registrar.registerReferenceProvider((ElementPattern)intentionActionBundleTagPattern, bundleReferenceProvider, 0.0);
    }

    private static ElementPattern createPattern(String[] tagNames, String ... attributeNames) {
        return XmlPatterns.xmlAttributeValue((String[])attributeNames).withSuperParent(2, (ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withName(tagNames)).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withName("idea-plugin")));
    }

    private static class MyResourceBundleReference
    extends ResourceBundleReference
    implements EmptyResolveMessageProvider {
        private MyResourceBundleReference(PsiElement element) {
            super(element, false);
        }

        @NotNull
        public Object[] getVariants() {
            final Project project = this.myElement.getProject();
            PropertiesReferenceManager referenceManager = PropertiesReferenceManager.getInstance((Project)project);
            final ArrayList variants = new ArrayList();
            referenceManager.processPropertiesFiles(GlobalSearchScopesCore.projectProductionScope((Project)project), new PropertiesFileProcessor(){

                public boolean process(String baseName, PropertiesFile propertiesFile) {
                    Icon icon = propertiesFile.getContainingFile().getIcon(2);
                    String relativePath = ProjectUtil.calcRelativeToProjectPath((VirtualFile)propertiesFile.getVirtualFile(), (Project)project);
                    variants.add(LookupElementBuilder.create((Object)propertiesFile, (String)baseName).withIcon(icon).withTailText(" (" + relativePath + ")", true));
                    return true;
                }
            }, (BundleNameEvaluator)this);
            Object[] objectArray = variants.toArray(new LookupElement[variants.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$MyResourceBundleReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Cannot resolve property bundle" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/impl/I18nReferenceContributor$MyResourceBundleReference", "getUnresolvedMessagePattern"));
            }
            return "Cannot resolve property bundle";
        }
    }
}

