/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.internal.InternalInspection;

public class FileEqualsUsageInspection
extends InternalInspection {
    static final String MESSAGE = "Do not use File.equals/hashCode/compareTo as they don't honor case-sensitivity on MacOS. Please use FileUtil.filesEquals/fileHashCode/compareFiles instead";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection", "buildInternalVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiElement resolved = methodExpression.resolve();
                if (!(resolved instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)resolved;
                PsiClass clazz = method.getContainingClass();
                if (clazz == null) {
                    return;
                }
                String methodName = method.getName();
                if ("java.io.File".equals(clazz.getQualifiedName()) && ("equals".equals(methodName) || "compareTo".equals(methodName) || "hashCode".equals(methodName))) {
                    holder.registerProblem((PsiReference)methodExpression, FileEqualsUsageInspection.MESSAGE, ProblemHighlightType.LIKE_DEPRECATED);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/FileEqualsUsageInspection", "buildInternalVisitor"));
        }
        return javaElementVisitor;
    }
}

