/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.internal.InternalInspection;

public class UndesirableClassUsageInspection
extends InternalInspection {
    private static final Map<String, String> CLASSES = ContainerUtil.immutableMapBuilder().put((Object)JList.class.getName(), (Object)JBList.class.getName()).put((Object)JTable.class.getName(), (Object)JBTable.class.getName()).put((Object)JTree.class.getName(), (Object)Tree.class.getName()).put((Object)JScrollPane.class.getName(), (Object)JBScrollPane.class.getName()).put((Object)JTabbedPane.class.getName(), (Object)JBTabbedPane.class.getName()).put((Object)JComboBox.class.getName(), (Object)ComboBox.class.getName()).put((Object)QueryExecutor.class.getName(), (Object)QueryExecutorBase.class.getName()).put((Object)BufferedImage.class.getName(), (Object)"UIUtil.createImage()").build();

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection", "buildInternalVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitNewExpression(PsiNewExpression expression) {
                PsiJavaCodeReferenceElement ref = expression.getClassReference();
                if (ref == null) {
                    return;
                }
                PsiElement res = ref.resolve();
                if (res == null) {
                    return;
                }
                String name = ((PsiClass)res).getQualifiedName();
                if (name == null) {
                    return;
                }
                String replacement = (String)CLASSES.get(name);
                if (replacement == null) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, "Please use '" + replacement + "' instead", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/internal/UndesirableClassUsageInspection", "buildInternalVisitor"));
        }
        return javaElementVisitor;
    }
}

