/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import icons.DevkitIcons;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdkConfigurable;
import org.jetbrains.idea.devkit.projectRoots.IntelliJPlatformProduct;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class IdeaJdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Icon ADD_SDK = DevkitIcons.Add_sdk;
    private static final Icon SDK_CLOSED = DevkitIcons.Sdk_closed;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.projectRoots.IdeaJdk");
    @NonNls
    private static final String LIB_DIR_NAME = "lib";
    @NonNls
    private static final String SRC_DIR_NAME = "src";
    @NonNls
    private static final String PLUGINS_DIR = "plugins";
    public static final String OUT_CLASSES = "/out/classes/production";

    public IdeaJdk() {
        super("IDEA JDK");
    }

    public Icon getIcon() {
        return SDK_CLOSED;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.idea" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.idea";
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = ADD_SDK;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getIconForAddAction"));
        }
        return icon;
    }

    public String suggestHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    @NotNull
    public String adjustSelectedSdkHome(@NotNull String homePath) {
        File home;
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "adjustSelectedSdkHome"));
        }
        if (SystemInfo.isMac && (home = new File(homePath, "Contents")).exists()) {
            String string = home.getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "adjustSelectedSdkHome"));
            }
            return string;
        }
        String string = super.adjustSelectedSdkHome(homePath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "adjustSelectedSdkHome"));
        }
        return string;
    }

    public boolean isValidSdkHome(String path) {
        if (IdeaJdk.isFromIDEAProject(path)) {
            return true;
        }
        File home = new File(path);
        if (!home.exists()) {
            return false;
        }
        return IdeaJdk.getBuildNumber(path) != null && IdeaJdk.getOpenApiJar(path) != null;
    }

    @Nullable
    private static File getOpenApiJar(String home) {
        String openapiJar = "openapi.jar";
        String platformApiJar = "platform-api.jar";
        File libDir = new File(home, LIB_DIR_NAME);
        File f = new File(libDir, "openapi.jar");
        if (f.exists()) {
            return f;
        }
        f = new File(libDir, "platform-api.jar");
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public static boolean isFromIDEAProject(String path) {
        File ultimate = new File(path, "idea.iml");
        File community = new File(path, "community-main.iml");
        return ultimate.exists() && ultimate.isFile() || community.exists() && community.isFile();
    }

    @Nullable
    public final String getVersionString(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getVersionString"));
        }
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk != null ? internalJavaSdk.getVersionString() : null;
    }

    @Nullable
    private static Sdk getInternalJavaSdk(Sdk sdk) {
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof Sandbox) {
            return ((Sandbox)data).getJavaSdk();
        }
        return null;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        if (IdeaJdk.isFromIDEAProject(sdkHome)) {
            return "Local IDEA [" + sdkHome + "]";
        }
        String buildNumber = IdeaJdk.getBuildNumber(sdkHome);
        return IntelliJPlatformProduct.fromBuildNumber(buildNumber).getName() + " " + (buildNumber != null ? buildNumber : "");
    }

    @Nullable
    public static String getBuildNumber(String ideaHome) {
        try {
            String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
            File file = new File(ideaHome, buildTxt);
            if (SystemInfo.isMac && !file.exists()) {
                file = new File(ideaHome, "build.txt");
            }
            return FileUtil.loadFile((File)file).trim();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static VirtualFile[] getIdeaLibrary(String home) {
        String plugins = home + File.separator + PLUGINS_DIR + File.separator;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        IdeaJdk.appendIdeaLibrary(home, result, "junit.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "JavaEE", result, "javaee-impl.jar", "jpa-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "PersistenceSupport", result, "persistence-impl.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "DatabaseTools", result, "database-impl.jar", "jdbc-console.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "css", result, "css.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "uml", result, "uml-support.jar");
        IdeaJdk.appendIdeaLibrary(plugins + "Spring", result, "spring.jar", "spring-el.jar", "spring-jsf.jar", "spring-persistence-integration.jar");
        return VfsUtilCore.toVirtualFileArray(result);
    }

    private static void appendIdeaLibrary(String libDirPath, ArrayList<VirtualFile> result, String ... forbidden) {
        File[] jars;
        Arrays.sort(forbidden);
        String path = libDirPath + File.separator + LIB_DIR_NAME;
        JarFileSystem jfs = JarFileSystem.getInstance();
        File lib = new File(path);
        if (lib.isDirectory() && (jars = lib.listFiles()) != null) {
            for (File jar : jars) {
                String name = jar.getName();
                if (!jar.isFile() || Arrays.binarySearch(forbidden, name) >= 0 || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                VirtualFile file = jfs.findFileByPath(jar.getPath() + "!/");
                LOG.assertTrue(file != null, (Object)(jar.getPath() + " not found"));
                result.add(file);
            }
        }
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk, @NotNull SdkModel sdkModel) {
        Sdk[] sdks;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "setupSdkPaths"));
        }
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "setupSdkPaths"));
        }
        Sandbox additionalData = (Sandbox)sdk.getSdkAdditionalData();
        if (additionalData != null) {
            additionalData.cleanupWatchedRoots();
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        ArrayList<String> javaSdks = new ArrayList<String>();
        for (Sdk jdk : sdks = sdkModel.getSdks()) {
            if (!IdeaJdk.isValidInternalJdk(sdk, jdk)) continue;
            javaSdks.add(jdk.getName());
        }
        if (javaSdks.isEmpty()) {
            JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(sdk);
            if (requiredVersion != null) {
                Messages.showErrorDialog((String)DevKitBundle.message("no.java.sdk.for.idea.sdk.found", requiredVersion), (String)"No Java SDK Found");
            } else {
                Messages.showErrorDialog((String)DevKitBundle.message("no.idea.sdk.version.found", new Object[0]), (String)"No Java SDK Found");
            }
            return false;
        }
        int choice = Messages.showChooseDialog((String)("Select Java SDK to be used for " + DevKitBundle.message("sdk.title", new Object[0])), (String)"Select Internal Java Platform", (String[])ArrayUtil.toStringArray(javaSdks), (String)((String)javaSdks.get(0)), (Icon)Messages.getQuestionIcon());
        if (choice != -1) {
            String name = (String)javaSdks.get(choice);
            Sdk jdk = sdkModel.findSdk(name);
            LOG.assertTrue(jdk != null);
            IdeaJdk.setupSdkPaths(sdkModificator, sdk.getHomePath(), jdk);
            sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Sandbox(IdeaJdk.getDefaultSandbox(), jdk, sdk));
            sdkModificator.setVersionString(jdk.getVersionString());
            sdkModificator.commitChanges();
            return true;
        }
        return false;
    }

    public static boolean isValidInternalJdk(Sdk ideaSdk, Sdk sdk) {
        SdkTypeId sdkType = sdk.getSdkType();
        if (sdkType instanceof JavaSdk) {
            JavaSdkVersion version = JavaSdk.getInstance().getVersion(sdk);
            JavaSdkVersion requiredVersion = IdeaJdk.getRequiredJdkVersion(ideaSdk);
            if (version != null && requiredVersion != null) {
                return version.isAtLeast(requiredVersion);
            }
        }
        return false;
    }

    @Nullable
    private static JavaSdkVersion getRequiredJdkVersion(Sdk ideaSdk) {
        if (IdeaJdk.isFromIDEAProject(ideaSdk.getHomePath())) {
            return JavaSdkVersion.JDK_1_8;
        }
        File apiJar = IdeaJdk.getOpenApiJar(ideaSdk.getHomePath());
        int classFileVersion = apiJar == null ? -1 : IdeaJdk.getIdeaClassFileVersion(apiJar);
        LanguageLevel languageLevel = classFileVersion <= 0 ? null : ClsParsingUtil.getLanguageLevelByVersion((int)classFileVersion);
        return languageLevel != null ? JavaSdkVersion.fromLanguageLevel((LanguageLevel)languageLevel) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getIdeaClassFileVersion(File apiJar) {
        try (ZipFile zipFile = new ZipFile(apiJar);){
            ZipEntry entry = zipFile.getEntry(ApplicationStarter.class.getName().replace('.', '/') + ".class");
            if (entry == null) return -1;
            try (DataInputStream stream = new DataInputStream(zipFile.getInputStream(entry));){
                if (stream.skip(6L) != 6L) return -1;
                int n = stream.readUnsignedShort();
                return n;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return -1;
    }

    public static void setupSdkPaths(SdkModificator sdkModificator, String sdkHome, Sdk internalJava) {
        IdeaJdk.addClasses(sdkModificator, internalJava);
        IdeaJdk.addDocs(sdkModificator, internalJava);
        IdeaJdk.addSources(sdkModificator, internalJava);
        if (IdeaJdk.isFromIDEAProject(sdkHome)) {
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            for (String prefix : Arrays.asList("community", "")) {
                for (String string : Arrays.asList(LIB_DIR_NAME, "build/kotlinc/lib/kotlin-runtime.jar", "xml/relaxng/lib")) {
                    File libDir = new File(sdkHome, FileUtil.toSystemDependentName((String)(prefix + "/" + string)));
                    if (!libDir.exists()) continue;
                    for (File file : JBIterable.of((Object[])libDir.listFiles()).append((Object)libDir)) {
                        String jarPath;
                        VirtualFile jar;
                        if (file.isDirectory() || !StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".jar") || (jar = jarFileSystem.findFileByPath(jarPath = FileUtil.toSystemIndependentName((String)file.getPath()) + "!/")) == null) continue;
                        sdkModificator.addRoot(jar, OrderRootType.CLASSES);
                    }
                }
            }
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            VirtualFile out = localFileSystem.refreshAndFindFileByPath(sdkHome + OUT_CLASSES);
            if (out != null) {
                List<String> suppressed = Arrays.asList("jps-plugin-system");
                for (VirtualFile dir : JBIterable.of((Object[])new VirtualFile[]{out.findChild("resources")}).append((Object[])out.getChildren())) {
                    String name;
                    if (!dir.isDirectory() || (name = dir.getName()).endsWith("-ide") || suppressed.contains(name) || !name.equals("ultimate-resources") && FileUtil.exists((String)FileUtil.toSystemDependentName((String)(dir.getPath() + "/META-INF/plugin.xml")))) continue;
                    sdkModificator.addRoot(dir, OrderRootType.CLASSES);
                }
            }
        } else {
            VirtualFile[] ideaLib;
            for (VirtualFile virtualFile : ideaLib = IdeaJdk.getIdeaLibrary(sdkHome)) {
                sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
            }
            IdeaJdk.addSources(new File(sdkHome), sdkModificator);
        }
    }

    static String getDefaultSandbox() {
        String defaultSandbox = "";
        try {
            defaultSandbox = new File(PathManager.getSystemPath()).getCanonicalPath() + File.separator + "plugins-sandbox";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return defaultSandbox;
    }

    private static void addSources(File file, SdkModificator sdkModificator) {
        File src = new File(new File(file, LIB_DIR_NAME), SRC_DIR_NAME);
        if (!src.exists()) {
            return;
        }
        File[] srcs = src.listFiles(pathname -> {
            String path = pathname.getPath();
            if (path.contains("generics")) {
                return false;
            }
            return path.endsWith(".jar") || path.endsWith(".zip");
        });
        for (int i = 0; srcs != null && i < srcs.length; ++i) {
            File jarFile = srcs[i];
            if (!jarFile.exists()) continue;
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
            jarFileSystem.setNoCopyJarForPath(path);
            VirtualFile vFile = jarFileSystem.findFileByPath(path);
            sdkModificator.addRoot(vFile, OrderRootType.SOURCES);
        }
    }

    private static void addClasses(SdkModificator sdkModificator, Sdk javaSdk) {
        IdeaJdk.addOrderEntries(OrderRootType.CLASSES, javaSdk, sdkModificator);
    }

    private static void addDocs(SdkModificator sdkModificator, Sdk javaSdk) {
        if (!IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), javaSdk, sdkModificator) && SystemInfo.isMac) {
            Sdk[] jdks;
            for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                IdeaJdk.addOrderEntries(JavadocOrderRootType.getInstance(), jdk, sdkModificator);
                break;
            }
        }
    }

    private static void addSources(SdkModificator sdkModificator, Sdk javaSdk) {
        if (javaSdk != null && !IdeaJdk.addOrderEntries(OrderRootType.SOURCES, javaSdk, sdkModificator)) {
            if (SystemInfo.isMac) {
                Sdk[] jdks;
                for (Sdk jdk : jdks = ProjectJdkTable.getInstance().getAllJdks()) {
                    if (!(jdk.getSdkType() instanceof JavaSdk)) continue;
                    IdeaJdk.addOrderEntries(OrderRootType.SOURCES, jdk, sdkModificator);
                    break;
                }
            } else {
                String homePath = javaSdk.getHomePath();
                if (homePath == null) {
                    return;
                }
                File jdkHome = new File(homePath).getParentFile();
                String srcZip = "src.zip";
                File jarFile = new File(jdkHome, "src.zip");
                if (jarFile.exists()) {
                    JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                    String path = jarFile.getAbsolutePath().replace(File.separatorChar, '/') + "!/";
                    jarFileSystem.setNoCopyJarForPath(path);
                    sdkModificator.addRoot(jarFileSystem.findFileByPath(path), OrderRootType.SOURCES);
                }
            }
        }
    }

    private static boolean addOrderEntries(OrderRootType orderRootType, Sdk sdk, SdkModificator toModificator) {
        String[] entries;
        boolean wasSmthAdded = false;
        for (String entry : entries = sdk.getRootProvider().getUrls(orderRootType)) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(entry);
            if (virtualFile == null) continue;
            toModificator.addRoot(virtualFile, orderRootType);
            wasSmthAdded = true;
        }
        return wasSmthAdded;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "createAdditionalDataConfigurable"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "createAdditionalDataConfigurable"));
        }
        return new IdeaJdkConfigurable(sdkModel, sdkModificator);
    }

    @Nullable
    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getBinPath"));
        }
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getBinPath(internalJavaSdk);
    }

    @Nullable
    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getToolsPath"));
        }
        Sdk jdk = IdeaJdk.getInternalJavaSdk(sdk);
        if (jdk != null && jdk.getVersionString() != null) {
            return JavaSdk.getInstance().getToolsPath(jdk);
        }
        return null;
    }

    @Nullable
    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getVMExecutablePath"));
        }
        Sdk internalJavaSdk = IdeaJdk.getInternalJavaSdk(sdk);
        return internalJavaSdk == null ? null : JavaSdk.getInstance().getVMExecutablePath(internalJavaSdk);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "saveAdditionalData"));
        }
        if (additionalData instanceof Sandbox) {
            try {
                ((Sandbox)additionalData).writeExternal(additional);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk sdk, Element additional) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "loadAdditionalData"));
        }
        Sandbox sandbox = new Sandbox(sdk);
        try {
            sandbox.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return sandbox;
    }

    @NotNull
    public String getPresentableName() {
        String string = DevKitBundle.message("sdk.title", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public static Sdk findIdeaJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return null;
        }
        if (jdk.getSdkType() instanceof IdeaJdk) {
            return jdk;
        }
        return null;
    }

    public static SdkType getInstance() {
        return SdkType.findInstance(IdeaJdk.class);
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "isRootTypeApplicable"));
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance() || type == AnnotationOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/idea/devkit/projectRoots/IdeaJdk", "getDefaultDocumentationUrl"));
        }
        return JavaSdk.getInstance().getDefaultDocumentationUrl(sdk);
    }
}

