/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;

class GotoTestDataAction
extends AnAction
implements Comparable {
    private final String myFilePath;
    private final Project myProject;

    public GotoTestDataAction(String filePath, Project project, Icon icon) {
        super("Go to " + FilePathSplittingPolicy.SPLIT_BY_SEPARATOR.getPresentableName(new File(filePath), 50), null, icon);
        this.myFilePath = filePath;
        this.myProject = project;
    }

    public void actionPerformed(AnActionEvent e) {
        RelativePoint point = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        TestDataNavigationHandler.navigate(point, Collections.singletonList(this.myFilePath), this.myProject);
    }

    public int compareTo(Object o) {
        return o instanceof GotoTestDataAction ? 0 : 1;
    }
}

