/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDataReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.literalExpression().annotationParam("com.intellij.testFramework.TestDataPath"), (PsiReferenceProvider)new TestDataReferenceProvider());
    }

    public static class TestDataReference
    extends FileReference {
        public TestDataReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "<init>"));
            }
            super(fileReferenceSet, range, index, text);
        }

        @NotNull
        public Object[] getVariants() {
            if (this.getIndex() == 0 && !StringUtil.startsWithChar((CharSequence)this.getFileReferenceSet().getPathString(), (char)'/')) {
                PsiDirectory contentPsiRoot;
                HashSet variants = ContainerUtil.newHashSet((Object[])super.getVariants());
                PsiDirectory projectPsiRoot = this.getProjectPsiRoot();
                if (projectPsiRoot != null) {
                    variants.add(FileInfoManager.getFileLookupItem((PsiElement)projectPsiRoot, (String)"$PROJECT_ROOT", (Icon)projectPsiRoot.getIcon(0)).withTypeText(projectPsiRoot.getVirtualFile().getPath(), true));
                }
                if ((contentPsiRoot = this.getContentPsiRoot()) != null) {
                    variants.add(FileInfoManager.getFileLookupItem((PsiElement)contentPsiRoot, (String)"$CONTENT_ROOT", (Icon)contentPsiRoot.getIcon(0)).withTypeText(contentPsiRoot.getVirtualFile().getPath(), true));
                }
                Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "getVariants"));
                }
                return objectArray;
            }
            Object[] objectArray = super.getVariants();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "getVariants"));
            }
            return objectArray;
        }

        @NotNull
        protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "innerResolve"));
            }
            if (this.getIndex() == 0 && StringUtil.startsWithChar((CharSequence)this.getText(), (char)'$')) {
                PsiDirectory contentPsiRoot;
                if ("$PROJECT_ROOT".equals(this.getText())) {
                    PsiDirectory projectPsiRoot = this.getProjectPsiRoot();
                    if (projectPsiRoot != null) {
                        ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)projectPsiRoot)};
                        if (resolveResultArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "innerResolve"));
                        }
                        return resolveResultArray;
                    }
                } else if ("$CONTENT_ROOT".equals(this.getText()) && (contentPsiRoot = this.getContentPsiRoot()) != null) {
                    ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)contentPsiRoot)};
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "innerResolve"));
                    }
                    return resolveResultArray;
                }
            }
            ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReference", "innerResolve"));
            }
            return resolveResultArray;
        }

        @Nullable
        private PsiDirectory getProjectPsiRoot() {
            Project project = this.getElement().getProject();
            VirtualFile projectDir = project.getBaseDir();
            if (projectDir != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findDirectory(projectDir);
            }
            return null;
        }

        @Nullable
        private PsiDirectory getContentPsiRoot() {
            VirtualFile contentRoot;
            Project project = this.getElement().getProject();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile file = this.getElement().getContainingFile().getOriginalFile().getVirtualFile();
            if (file != null && (contentRoot = fileIndex.getContentRootForFile(file)) != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return psiManager.findDirectory(contentRoot);
            }
            return null;
        }
    }

    private static class TestDataReferenceSet
    extends FileReferenceSet {
        public TestDataReferenceSet(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReferenceSet", "<init>"));
            }
            super(element);
        }

        public boolean isEmptyPathAllowed() {
            return false;
        }

        public boolean isAbsolutePathReference() {
            return super.isAbsolutePathReference() || StringUtil.startsWithChar((CharSequence)this.getPathString(), (char)'$');
        }

        public FileReference createFileReference(TextRange range, int index, String text) {
            return new TestDataReference(this, range, index, text);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
            return DIRECTORY_FILTER;
        }
    }

    private static class TestDataReferenceProvider
    extends PsiReferenceProvider {
        private TestDataReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReferenceProvider", "getReferencesByElement"));
            }
            TestDataReferenceSet referenceSet = new TestDataReferenceSet(element);
            referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, FileReferenceSet.ABSOLUTE_TOP_LEVEL);
            FileReference[] fileReferenceArray = referenceSet.getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceContributor$TestDataReferenceProvider", "getReferencesByElement"));
            }
            return fileReferenceArray;
        }
    }
}

