/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.client.methods;

import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.version.DeltaVConstants;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaselineControlMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(BaselineControlMethod.class);

    public BaselineControlMethod(String uri) {
        super(uri);
    }

    public BaselineControlMethod(String uri, String baselineHref) throws IOException {
        super(uri);
        if (baselineHref != null) {
            try {
                Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
                Element el = DomUtil.addChildElement(document, "baseline-control", DeltaVConstants.NAMESPACE);
                el.appendChild(DomUtil.hrefToXml(baselineHref, document));
                this.setRequestBody(document);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public String getName() {
        return "BASELINE-CONTROL";
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

