/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.client.methods;

import hidden.org.apache.commons.httpclient.Header;
import hidden.org.apache.commons.httpclient.HttpConnection;
import hidden.org.apache.commons.httpclient.HttpState;
import hidden.org.apache.jackrabbit.webdav.DavConstants;
import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import hidden.org.apache.jackrabbit.webdav.header.DepthHeader;
import hidden.org.apache.jackrabbit.webdav.header.TimeoutHeader;
import hidden.org.apache.jackrabbit.webdav.observation.ObservationConstants;
import hidden.org.apache.jackrabbit.webdav.observation.Subscription;
import hidden.org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import hidden.org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.w3c.dom.Element;

public class SubscribeMethod
extends DavMethodBase
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(SubscribeMethod.class);
    private SubscriptionDiscovery subscriptionDiscovery;

    public SubscribeMethod(String uri, SubscriptionInfo subscriptionInfo) throws IOException {
        this(uri, subscriptionInfo, null);
    }

    public SubscribeMethod(String uri, SubscriptionInfo subscriptionInfo, String subscriptionId) throws IOException {
        super(uri);
        long to;
        if (subscriptionInfo == null) {
            throw new IllegalArgumentException("SubscriptionInfo must not be null.");
        }
        if (subscriptionId != null) {
            this.setRequestHeader(new CodedUrlHeader("SubscriptionId", subscriptionId));
        }
        if ((to = subscriptionInfo.getTimeOut()) != Integer.MIN_VALUE) {
            this.setRequestHeader(new TimeoutHeader(subscriptionInfo.getTimeOut()));
        }
        this.setRequestHeader(new DepthHeader(subscriptionInfo.isDeep()));
        this.setRequestBody(subscriptionInfo);
    }

    public SubscriptionDiscovery getResponseAsSubscriptionDiscovery() throws IOException, DavException {
        this.checkUsed();
        if (this.subscriptionDiscovery != null) {
            return this.subscriptionDiscovery;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), this.getName() + " resulted with unexpected status: " + this.getStatusLine());
    }

    public String getSubscriptionId() {
        this.checkUsed();
        Header sbHeader = this.getResponseHeader("SubscriptionId");
        if (sbHeader != null) {
            CodedUrlHeader cuh = new CodedUrlHeader("SubscriptionId", sbHeader.getValue());
            return cuh.getCodedUrl();
        }
        return null;
    }

    public String getName() {
        return "SUBSCRIBE";
    }

    protected boolean isSuccess(int statusCode) {
        return 200 == statusCode;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getSuccess()) {
            try {
                this.setSuccess(this.buildDiscoveryFromRoot(this.getRootElement()));
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.setSuccess(false);
            }
        }
    }

    private boolean buildDiscoveryFromRoot(Element root) {
        if (DomUtil.matches(root, "prop", DavConstants.NAMESPACE) && DomUtil.hasChildElement(root, SUBSCRIPTIONDISCOVERY.getName(), SUBSCRIPTIONDISCOVERY.getNamespace())) {
            Element sdElem = DomUtil.getChildElement(root, SUBSCRIPTIONDISCOVERY.getName(), SUBSCRIPTIONDISCOVERY.getNamespace());
            SubscriptionDiscovery sd = SubscriptionDiscovery.createFromXml(sdElem);
            if (((Subscription[])sd.getValue()).length > 0) {
                this.subscriptionDiscovery = sd;
                return true;
            }
            log.debug("Missing 'subscription' elements in SUBSCRIBE response body. At least a single subscription must be present if SUBSCRIBE was successful.");
        } else {
            log.debug("Missing DAV:prop response body in SUBSCRIBE method.");
        }
        return false;
    }
}

