/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import gnu.trove.THashMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.DefaultWagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.WagonException;
import org.jetbrains.idea.maven.server.embedder.UnresolvedArtifactsCollector;

public class CustomWagonManager
extends DefaultWagonManager {
    private UnresolvedArtifactsCollector myUnresolvedCollector;
    private final ThreadLocal<Boolean> myInBatchResolve = new ThreadLocal();
    private final Map<String, Boolean> myResolutionCache = new THashMap();
    private final ReentrantReadWriteLock myCacheLock = new ReentrantReadWriteLock();
    private final Lock myCacheReadLock = this.myCacheLock.readLock();
    private final Lock myCacheWriteLock = this.myCacheLock.writeLock();

    public void customize(boolean failOnUnresolved) {
        this.myUnresolvedCollector = new UnresolvedArtifactsCollector(failOnUnresolved);
    }

    public void reset() {
        this.myUnresolvedCollector = null;
    }

    public UnresolvedArtifactsCollector getUnresolvedCollector() {
        return this.myUnresolvedCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getArtifact(Artifact artifact, List remoteRepositories) throws TransferFailedException, ResourceDoesNotExistException {
        block5: {
            this.myInBatchResolve.set(Boolean.TRUE);
            try {
                if (this.takeFromCache(artifact)) break block5;
                try {
                    super.getArtifact(artifact, remoteRepositories);
                }
                catch (WagonException wagonException) {
                    // empty catch block
                }
                this.cache(artifact);
                this.myUnresolvedCollector.collectAndSetResolved(artifact);
            }
            finally {
                this.myInBatchResolve.set(Boolean.FALSE);
            }
        }
    }

    public void getArtifact(Artifact artifact, ArtifactRepository repository) throws TransferFailedException, ResourceDoesNotExistException {
        if (this.myInBatchResolve.get() == Boolean.TRUE) {
            super.getArtifact(artifact, repository);
            return;
        }
        if (!this.takeFromCache(artifact)) {
            try {
                super.getArtifact(artifact, repository);
            }
            catch (WagonException wagonException) {
                // empty catch block
            }
            this.cache(artifact);
            this.myUnresolvedCollector.collectAndSetResolved(artifact);
        }
    }

    public void getArtifactMetadata(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        super.getArtifactMetadata(metadata, repository, destination, checksumPolicy);
    }

    public void getArtifactMetadataFromDeploymentRepository(ArtifactMetadata metadata, ArtifactRepository repository, File destination, String checksumPolicy) throws TransferFailedException, ResourceDoesNotExistException {
        super.getArtifactMetadataFromDeploymentRepository(metadata, repository, destination, checksumPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean takeFromCache(Artifact artifact) {
        boolean fileWasDeleted;
        Boolean wasResolved;
        String key = this.getKey(artifact);
        this.myCacheReadLock.lock();
        try {
            wasResolved = this.myResolutionCache.get(key);
            if (wasResolved == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.myCacheReadLock.unlock();
        }
        boolean bl = fileWasDeleted = wasResolved != false && !artifact.getFile().exists();
        if (fileWasDeleted) {
            this.myCacheWriteLock.lock();
            try {
                this.myResolutionCache.remove(key);
            }
            finally {
                this.myCacheWriteLock.unlock();
            }
            return false;
        }
        artifact.setResolved(wasResolved.booleanValue());
        return true;
    }

    private void cache(Artifact artifact) {
        String key = this.getKey(artifact);
        this.myCacheWriteLock.lock();
        try {
            this.myResolutionCache.put(key, artifact.isResolved());
        }
        finally {
            this.myCacheWriteLock.unlock();
        }
    }

    private String getKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getVersion() + ":" + artifact.getClassifier();
    }
}

