/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnUtil;

public class SvnCompatibilityChecker {
    private final Project myProject;
    private static final long ourFrequency = 10L;
    private static final long ourInvocationMax = 10L;
    private static final long ourInitCounter = 3L;
    private long myCounter;
    private long myDownStartCounter;
    private long myInvocationCounter;
    private final Object myLock = new Object();

    public SvnCompatibilityChecker(Project project) {
        this.myProject = project;
        this.myCounter = 0L;
        this.myDownStartCounter = 3L;
        this.myInvocationCounter = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportNoRoots(final List<VirtualFile> result) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInvocationCounter >= 10L) {
                return;
            }
            ++this.myCounter;
            --this.myDownStartCounter;
            if (this.myCounter > 10L || this.myDownStartCounter >= 0L) {
                this.myCounter = 0L;
                ++this.myInvocationCounter;
                final Application application = ApplicationManager.getApplication();
                application.executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<VirtualFile> suspicious = new ArrayList<VirtualFile>();
                        for (VirtualFile vf : result) {
                            if (!SvnUtil.seemsLikeVersionedDir(vf)) continue;
                            suspicious.add(vf);
                        }
                        if (!suspicious.isEmpty()) {
                            final String message = suspicious.size() == 1 ? "Root '" + ((VirtualFile)suspicious.get(0)).getPresentableName() + "' is likely to be of unsupported Subversion format" : "Some roots are likely to be of unsupported Subversion format";
                            application.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    new VcsBalloonProblemNotifier(SvnCompatibilityChecker.this.myProject, message, MessageType.WARNING).run();
                                }
                            }, ModalityState.NON_MODAL, new Condition(){

                                public boolean value(Object o) {
                                    return !SvnCompatibilityChecker.this.myProject.isOpen() || SvnCompatibilityChecker.this.myProject.isDisposed();
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

