/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.dialogs.ShareDialog;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class ShareProjectAction
extends BasicAction {
    @Override
    protected String getActionName(AbstractVcs vcs) {
        return SvnBundle.message("share.directory.action", new Object[0]);
    }

    @Override
    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null || ProjectLevelVcsManager.getInstance((Project)project).isBackgroundVcsOperationRunning()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null || files.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        boolean enabled = false;
        boolean visible = false;
        if (files.length == 1 && files[0].isDirectory()) {
            visible = true;
            if (!SvnStatusUtil.isUnderControl(project, files[0])) {
                enabled = true;
            }
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(visible);
    }

    @Override
    protected boolean isEnabled(Project project, SvnVcs vcs, VirtualFile file) {
        return false;
    }

    @Override
    protected boolean needsFiles() {
        return true;
    }

    public static boolean share(Project project, VirtualFile file) throws VcsException {
        return ShareProjectAction.performImpl(project, SvnVcs.getInstance(project), file);
    }

    @Override
    protected void perform(Project project, SvnVcs activeVcs, VirtualFile file, DataContext context) throws VcsException {
        ShareProjectAction.performImpl(project, activeVcs, file);
    }

    private static boolean performImpl(final Project project, final SvnVcs activeVcs, final VirtualFile file) throws VcsException {
        final ShareDialog shareDialog = new ShareDialog(project, file.getName());
        shareDialog.show();
        final String parent = shareDialog.getSelectedURL();
        if (shareDialog.isOK() && parent != null) {
            int promptAnswer;
            boolean folderEmpty;
            Ref actionStarted = new Ref((Object)Boolean.TRUE);
            final Exception[] error = new Exception[1];
            final ShareDialog.ShareTarget shareTarget = shareDialog.getShareTarget();
            final ProgressManager progressManager = ProgressManager.getInstance();
            if (ShareDialog.ShareTarget.useSelected.equals((Object)shareTarget) && !(folderEmpty = ShareProjectAction.checkRemoteFolder(project, activeVcs, parent, progressManager)) && 0 != (promptAnswer = Messages.showYesNoDialog((Project)project, (String)("Remote folder \"" + parent + "\" is not empty.\nDo you want to continue sharing?"), (String)"Share directory", (Icon)Messages.getWarningIcon()))) {
                return false;
            }
            final WorkingCopyFormat format = SvnCheckoutProvider.promptForWCopyFormat(VfsUtilCore.virtualToIoFile((VirtualFile)file), project);
            actionStarted.set((Object)(format != WorkingCopyFormat.UNKNOWN ? 1 : 0));
            if (format == WorkingCopyFormat.UNKNOWN) {
                return true;
            }
            ExclusiveBackgroundVcsAction.run(project, new Runnable(){

                @Override
                public void run() {
                    progressManager.runProcessWithProgressSynchronously(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Pair pair;
                                SVNRevision revision;
                                SVNURL checkoutUrl;
                                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                                File path = new File(file.getPath());
                                SvnWorkingCopyFormatHolder.setPresetFormat(format);
                                SVNURL parenUrl = SVNURL.parseURIEncoded((String)parent);
                                String commitText = shareDialog.getCommitText();
                                if (ShareDialog.ShareTarget.useSelected.equals((Object)shareTarget)) {
                                    checkoutUrl = parenUrl;
                                    revision = SVNRevision.HEAD;
                                } else if (ShareDialog.ShareTarget.useProjectName.equals((Object)shareTarget)) {
                                    pair = ShareProjectAction.createRemoteFolder(activeVcs, parenUrl, file.getName(), commitText);
                                    revision = (SVNRevision)pair.getFirst();
                                    checkoutUrl = (SVNURL)pair.getSecond();
                                } else {
                                    pair = ShareProjectAction.createRemoteFolder(activeVcs, parenUrl, file.getName(), commitText);
                                    Pair trunkPair = ShareProjectAction.createRemoteFolder(activeVcs, (SVNURL)pair.getSecond(), "trunk", commitText);
                                    checkoutUrl = (SVNURL)trunkPair.getSecond();
                                    revision = (SVNRevision)trunkPair.getFirst();
                                    if (shareDialog.createStandardStructure()) {
                                        ShareProjectAction.createRemoteFolder(activeVcs, (SVNURL)pair.getSecond(), "branches", commitText);
                                        ShareProjectAction.createRemoteFolder(activeVcs, (SVNURL)pair.getSecond(), "tags", commitText);
                                    }
                                }
                                if (indicator != null) {
                                    indicator.checkCanceled();
                                    indicator.setText(SvnBundle.message("share.directory.checkout.back.progress.text", checkoutUrl.toString()));
                                }
                                ClientFactory factory = SvnCheckoutProvider.getFactory(activeVcs, format);
                                factory.createCheckoutClient().checkout(SvnTarget.fromURL((SVNURL)checkoutUrl), path, revision, Depth.INFINITY, false, false, format, null);
                                ShareProjectAction.addRecursively(activeVcs, factory, file);
                            }
                            catch (SVNException e) {
                                error[0] = e;
                            }
                            catch (VcsException e) {
                                error[0] = e;
                            }
                            finally {
                                activeVcs.invokeRefreshSvnRoots();
                                SvnWorkingCopyFormatHolder.setPresetFormat(null);
                            }
                        }
                    }, SvnBundle.message("share.directory.title", new Object[0]), true, project);
                }
            });
            if (Boolean.TRUE.equals(actionStarted.get())) {
                if (error[0] != null) {
                    throw new VcsException(error[0].getMessage());
                }
                Messages.showInfoMessage((Project)project, (String)SvnBundle.message("share.directory.info.message", file.getName()), (String)SvnBundle.message("share.directory.title", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private static boolean checkRemoteFolder(Project project, final SvnVcs activeVcs, final String parent, ProgressManager progressManager) throws VcsException {
        final VcsException[] exc = new VcsException[1];
        final boolean[] folderEmpty = new boolean[1];
        progressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    folderEmpty[0] = SvnUtil.remoteFolderIsEmpty(activeVcs, parent);
                }
                catch (VcsException e) {
                    exc[0] = e;
                }
            }
        }, "Check remote folder contents", false, project);
        if (exc[0] != null) {
            throw exc[0];
        }
        return folderEmpty[0];
    }

    private static Pair<SVNRevision, SVNURL> createRemoteFolder(@NotNull SvnVcs vcs, @NotNull SVNURL parent, String folderName, String commitText) throws VcsException, SVNException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/idea/svn/actions/ShareProjectAction", "createRemoteFolder"));
        }
        SVNURL url = parent.appendPath(folderName, false);
        String urlText = url.toString();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("share.directory.create.dir.progress.text", urlText));
        }
        String message = SvnBundle.message("share.directory.commit.message", folderName, ApplicationNamesInfo.getInstance().getFullProductName(), commitText);
        SvnTarget target = SvnTarget.fromURL((SVNURL)url);
        long revision = vcs.getFactoryFromSettings().createBrowseClient().createDirectory(target, message, false);
        return Pair.create((Object)SVNRevision.create((long)revision), (Object)url);
    }

    @Override
    protected void doVcsRefresh(Project project, VirtualFile file) {
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
    }

    private static void addRecursively(@NotNull SvnVcs activeVcs, final @NotNull ClientFactory factory, VirtualFile file) throws VcsException {
        if (activeVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeVcs", "org/jetbrains/idea/svn/actions/ShareProjectAction", "addRecursively"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/actions/ShareProjectAction", "addRecursively"));
        }
        SvnExcludingIgnoredOperation operation = new SvnExcludingIgnoredOperation(activeVcs.getProject(), new SvnExcludingIgnoredOperation.Operation(){

            @Override
            public void doOperation(VirtualFile virtualFile) throws VcsException {
                File ioFile = new File(virtualFile.getPath());
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText(SvnBundle.message("share.or.import.add.progress.text", virtualFile.getPath()));
                }
                factory.createAddClient().add(ioFile, Depth.EMPTY, false, false, true, null);
            }
        }, Depth.INFINITY);
        operation.execute(file);
    }

    @Override
    protected void batchPerform(Project project, SvnVcs activeVcs, VirtualFile[] file, DataContext context) throws VcsException {
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }
}

