/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public abstract class BaseSvnClient
implements SvnClient {
    protected SvnVcs myVcs;
    protected ClientFactory myFactory;
    protected boolean myIsActive;

    @Override
    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "getVcs"));
        }
        return svnVcs;
    }

    @Override
    public void setVcs(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/BaseSvnClient", "setVcs"));
        }
        this.myVcs = vcs;
    }

    @Override
    @NotNull
    public ClientFactory getFactory() {
        ClientFactory clientFactory = this.myFactory;
        if (clientFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "getFactory"));
        }
        return clientFactory;
    }

    @Override
    public void setFactory(@NotNull ClientFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/api/BaseSvnClient", "setFactory"));
        }
        this.myFactory = factory;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.myIsActive = isActive;
    }

    protected void assertUrl(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertUrl"));
        }
        if (!target.isURL()) {
            throw new IllegalArgumentException("Target should be url " + target);
        }
    }

    protected void assertFile(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertFile"));
        }
        if (!target.isFile()) {
            throw new IllegalArgumentException("Target should be file " + target);
        }
    }

    protected void assertDirectory(@NotNull SvnTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "assertDirectory"));
        }
        this.assertFile(target);
        if (!target.getFile().isDirectory()) {
            throw new IllegalArgumentException("Target should be directory " + target);
        }
    }

    protected void validateFormat(@NotNull WorkingCopyFormat format, @NotNull Collection<WorkingCopyFormat> supported) throws VcsException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "org/jetbrains/idea/svn/api/BaseSvnClient", "validateFormat"));
        }
        if (supported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supported", "org/jetbrains/idea/svn/api/BaseSvnClient", "validateFormat"));
        }
        if (!supported.contains((Object)format)) {
            throw new VcsException(String.format("%s format is not supported. Supported formats are: %s.", format.getName(), StringUtil.join(supported, (String)",")));
        }
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws SvnBindException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        CommandExecutor commandExecutor = this.execute(vcs, target, null, name, parameters, listener);
        if (commandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        return commandExecutor;
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable File workingDirectory, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener) throws SvnBindException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        Command command = this.newCommand(name);
        command.put(parameters);
        CommandExecutor commandExecutor = this.execute(vcs, target, workingDirectory, command, listener);
        if (commandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        return commandExecutor;
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable File workingDirectory, @NotNull Command command, @Nullable LineCommandListener listener) throws SvnBindException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        command.setTarget(target);
        command.setWorkingDirectory(workingDirectory);
        command.setResultBuilder(listener);
        CommandExecutor commandExecutor = this.newRuntime(vcs).runWithAuthenticationAttempt(command);
        if (commandExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "execute"));
        }
        return commandExecutor;
    }

    @NotNull
    public Command newCommand(@NotNull SvnCommandName name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/idea/svn/api/BaseSvnClient", "newCommand"));
        }
        Command command = new Command(name);
        if (command == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "newCommand"));
        }
        return command;
    }

    @NotNull
    public CommandRuntime newRuntime(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/BaseSvnClient", "newRuntime"));
        }
        CommandRuntime commandRuntime = new CommandRuntime(vcs, new AuthenticationService(vcs, this.myIsActive));
        if (commandRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "newRuntime"));
        }
        return commandRuntime;
    }

    protected static void callHandler(@Nullable ProgressTracker handler, @NotNull ProgressEvent event) throws VcsException {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/svn/api/BaseSvnClient", "callHandler"));
        }
        if (handler != null) {
            try {
                handler.consume(event);
            }
            catch (SVNException e) {
                throw new SvnBindException(e);
            }
        }
    }

    @NotNull
    protected static ProgressEvent createEvent(@NotNull File path, @Nullable EventAction action) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/api/BaseSvnClient", "createEvent"));
        }
        ProgressEvent progressEvent = new ProgressEvent(path, 0L, null, null, action, null, null);
        if (progressEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "createEvent"));
        }
        return progressEvent;
    }

    @Nullable
    protected static ISVNEventHandler toEventHandler(final @Nullable ProgressTracker handler) {
        ISVNEventHandler result = null;
        if (handler != null) {
            result = new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double progress) throws SVNException {
                    handler.consume(ProgressEvent.create(event));
                }

                public void checkCancelled() throws SVNCancelException {
                    handler.checkCancelled();
                }
            };
        }
        return result;
    }

    @Nullable
    protected static SVNDiffOptions toDiffOptions(@Nullable DiffOptions options) {
        return options != null ? new SVNDiffOptions(options.isIgnoreAllWhitespace(), options.isIgnoreAmountOfWhitespace(), options.isIgnoreEOLStyle()) : null;
    }

    @Nullable
    protected static SVNDepth toDepth(@Nullable Depth depth) {
        return depth != null ? SVNDepth.fromString((String)depth.getName()) : null;
    }

    @NotNull
    protected static SVNRevision notNullize(@Nullable SVNRevision revision) {
        SVNRevision sVNRevision = revision != null ? revision : SVNRevision.UNDEFINED;
        if (sVNRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/BaseSvnClient", "notNullize"));
        }
        return sVNRevision;
    }
}

