/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.RepositoryFeaturesClient;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.lock.LockClient;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.update.RelocateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;

public abstract class ClientFactory {
    @NotNull
    protected SvnVcs myVcs;
    protected AddClient addClient;
    protected AnnotateClient annotateClient;
    protected ContentClient contentClient;
    protected HistoryClient historyClient;
    protected RevertClient revertClient;
    protected DeleteClient deleteClient;
    protected StatusClient statusClient;
    protected InfoClient infoClient;
    protected CopyMoveClient copyMoveClient;
    protected ConflictClient conflictClient;
    protected PropertyClient propertyClient;
    protected MergeClient mergeClient;
    protected ChangeListClient changeListClient;
    protected CheckoutClient checkoutClient;
    protected LockClient myLockClient;
    protected CleanupClient myCleanupClient;
    protected RelocateClient myRelocateClient;
    protected VersionClient myVersionClient;
    protected ImportClient myImportClient;
    protected ExportClient myExportClient;
    protected UpgradeClient myUpgradeClient;
    protected BrowseClient myBrowseClient;
    protected DiffClient myDiffClient;
    protected CheckinClient myCheckinClient;
    protected RepositoryFeaturesClient myRepositoryFeaturesClient;
    @NotNull
    private final Map<Class, Class> myClientImplementations;

    protected ClientFactory(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/api/ClientFactory", "<init>"));
        }
        this.myClientImplementations = ContainerUtil.newHashMap();
        this.myVcs = vcs;
        this.setup();
    }

    protected abstract void setup();

    protected <T extends SvnClient> void put(@NotNull Class<T> type, @NotNull Class<? extends T> implementation) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/api/ClientFactory", "put"));
        }
        if (implementation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implementation", "org/jetbrains/idea/svn/api/ClientFactory", "put"));
        }
        this.myClientImplementations.put(type, implementation);
    }

    @NotNull
    protected <T extends SvnClient> Class<? extends T> get(@NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/api/ClientFactory", "get"));
        }
        Class implementation = this.myClientImplementations.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("No implementation registered for " + type);
        }
        Class clazz = implementation;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "get"));
        }
        return clazz;
    }

    @NotNull
    public <T extends SvnClient> T create(@NotNull Class<T> type, boolean isActive) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/api/ClientFactory", "create"));
        }
        SvnClient client = this.prepare((SvnClient)ReflectionUtil.newInstance(this.get(type)));
        client.setIsActive(isActive);
        SvnClient svnClient = client;
        if (svnClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "create"));
        }
        return (T)svnClient;
    }

    @NotNull
    public AddClient createAddClient() {
        AddClient addClient = this.prepare(this.addClient);
        if (addClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createAddClient"));
        }
        return addClient;
    }

    @NotNull
    public AnnotateClient createAnnotateClient() {
        AnnotateClient annotateClient = this.prepare(this.annotateClient);
        if (annotateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createAnnotateClient"));
        }
        return annotateClient;
    }

    @NotNull
    public ContentClient createContentClient() {
        ContentClient contentClient = this.prepare(this.contentClient);
        if (contentClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createContentClient"));
        }
        return contentClient;
    }

    @NotNull
    public HistoryClient createHistoryClient() {
        HistoryClient historyClient = this.prepare(this.historyClient);
        if (historyClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createHistoryClient"));
        }
        return historyClient;
    }

    @NotNull
    public RevertClient createRevertClient() {
        RevertClient revertClient = this.prepare(this.revertClient);
        if (revertClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createRevertClient"));
        }
        return revertClient;
    }

    @NotNull
    public StatusClient createStatusClient() {
        StatusClient statusClient = this.prepare(this.statusClient);
        if (statusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createStatusClient"));
        }
        return statusClient;
    }

    @NotNull
    public StatusClient createStatusClient(@Nullable ISVNStatusFileProvider provider, @NotNull ProgressTracker handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/api/ClientFactory", "createStatusClient"));
        }
        StatusClient statusClient = this.createStatusClient();
        if (statusClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createStatusClient"));
        }
        return statusClient;
    }

    @NotNull
    public InfoClient createInfoClient() {
        InfoClient infoClient = this.prepare(this.infoClient);
        if (infoClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createInfoClient"));
        }
        return infoClient;
    }

    @NotNull
    public abstract UpdateClient createUpdateClient();

    @NotNull
    public DeleteClient createDeleteClient() {
        DeleteClient deleteClient = this.prepare(this.deleteClient);
        if (deleteClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createDeleteClient"));
        }
        return deleteClient;
    }

    @NotNull
    public CopyMoveClient createCopyMoveClient() {
        CopyMoveClient copyMoveClient = this.prepare(this.copyMoveClient);
        if (copyMoveClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCopyMoveClient"));
        }
        return copyMoveClient;
    }

    @NotNull
    public ConflictClient createConflictClient() {
        ConflictClient conflictClient = this.prepare(this.conflictClient);
        if (conflictClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createConflictClient"));
        }
        return conflictClient;
    }

    @NotNull
    public PropertyClient createPropertyClient() {
        PropertyClient propertyClient = this.prepare(this.propertyClient);
        if (propertyClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createPropertyClient"));
        }
        return propertyClient;
    }

    @NotNull
    public MergeClient createMergeClient() {
        MergeClient mergeClient = this.prepare(this.mergeClient);
        if (mergeClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createMergeClient"));
        }
        return mergeClient;
    }

    @NotNull
    public ChangeListClient createChangeListClient() {
        ChangeListClient changeListClient = this.prepare(this.changeListClient);
        if (changeListClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createChangeListClient"));
        }
        return changeListClient;
    }

    @NotNull
    public CheckoutClient createCheckoutClient() {
        CheckoutClient checkoutClient = this.prepare(this.checkoutClient);
        if (checkoutClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCheckoutClient"));
        }
        return checkoutClient;
    }

    @NotNull
    public LockClient createLockClient() {
        LockClient lockClient = this.prepare(this.myLockClient);
        if (lockClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createLockClient"));
        }
        return lockClient;
    }

    @NotNull
    public CleanupClient createCleanupClient() {
        CleanupClient cleanupClient = this.prepare(this.myCleanupClient);
        if (cleanupClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCleanupClient"));
        }
        return cleanupClient;
    }

    @NotNull
    public RelocateClient createRelocateClient() {
        RelocateClient relocateClient = this.prepare(this.myRelocateClient);
        if (relocateClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createRelocateClient"));
        }
        return relocateClient;
    }

    @NotNull
    public VersionClient createVersionClient() {
        VersionClient versionClient = this.prepare(this.myVersionClient);
        if (versionClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createVersionClient"));
        }
        return versionClient;
    }

    @NotNull
    public ImportClient createImportClient() {
        ImportClient importClient = this.prepare(this.myImportClient);
        if (importClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createImportClient"));
        }
        return importClient;
    }

    @NotNull
    public ExportClient createExportClient() {
        ExportClient exportClient = this.prepare(this.myExportClient);
        if (exportClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createExportClient"));
        }
        return exportClient;
    }

    @NotNull
    public UpgradeClient createUpgradeClient() {
        UpgradeClient upgradeClient = this.prepare(this.myUpgradeClient);
        if (upgradeClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createUpgradeClient"));
        }
        return upgradeClient;
    }

    @NotNull
    public BrowseClient createBrowseClient() {
        BrowseClient browseClient = this.prepare(this.myBrowseClient);
        if (browseClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createBrowseClient"));
        }
        return browseClient;
    }

    @NotNull
    public DiffClient createDiffClient() {
        DiffClient diffClient = this.prepare(this.myDiffClient);
        if (diffClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createDiffClient"));
        }
        return diffClient;
    }

    @NotNull
    public CheckinClient createCheckinClient() {
        CheckinClient checkinClient = this.prepare(this.myCheckinClient);
        if (checkinClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createCheckinClient"));
        }
        return checkinClient;
    }

    @NotNull
    public RepositoryFeaturesClient createRepositoryFeaturesClient() {
        RepositoryFeaturesClient repositoryFeaturesClient = this.prepare(this.myRepositoryFeaturesClient);
        if (repositoryFeaturesClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "createRepositoryFeaturesClient"));
        }
        return repositoryFeaturesClient;
    }

    @NotNull
    protected <T extends SvnClient> T prepare(@NotNull T client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/idea/svn/api/ClientFactory", "prepare"));
        }
        client.setVcs(this.myVcs);
        client.setFactory(this);
        client.setIsActive(true);
        T t = client;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/ClientFactory", "prepare"));
        }
        return t;
    }
}

