/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import org.jetbrains.annotations.NotNull;

public enum AcceptResult {
    REJECTED("r"),
    ACCEPTED_TEMPORARILY("t"),
    ACCEPTED_PERMANENTLY("p");

    private static final AcceptResult[] allValues;
    @NotNull
    private final String code;

    private AcceptResult(String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "org/jetbrains/idea/svn/auth/AcceptResult", "<init>"));
        }
        this.code = code;
    }

    public String toString() {
        return this.code;
    }

    @NotNull
    public static AcceptResult from(int value) {
        if (value < 0 || value >= allValues.length) {
            throw new IllegalArgumentException("Unknown AcceptResult - " + value);
        }
        AcceptResult acceptResult = allValues[value];
        if (acceptResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AcceptResult", "from"));
        }
        return acceptResult;
    }

    static {
        allValues = AcceptResult.values();
    }
}

