/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.PasswordAuthentication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class ProxyCallback
extends AuthCallbackCase {
    private static final Logger LOG = Logger.getInstance(ProxyCallback.class);
    private static final String CANNOT_AUTHENTICATE_TO_PROXY = "Could not authenticate to proxy server";
    private static final String PROXY_AUTHENTICATION_FAILED = "Proxy authentication failed";
    private PasswordAuthentication myProxyAuthentication;

    ProxyCallback(@NotNull AuthenticationService authenticationService, SVNURL url) {
        if (authenticationService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authenticationService", "org/jetbrains/idea/svn/commandLine/ProxyCallback", "<init>"));
        }
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(CANNOT_AUTHENTICATE_TO_PROXY) || error.contains(PROXY_AUTHENTICATION_FAILED);
    }

    @Override
    boolean getCredentials(String errText) throws SvnBindException {
        boolean result = false;
        if (this.myUrl == null) {
            LOG.info("Proxy callback could handle error text, but repository url is null", new Throwable());
            result = true;
        } else if (this.myAuthenticationService.haveDataForTmpConfig()) {
            this.myProxyAuthentication = this.myAuthenticationService.getProxyAuthentication(this.myUrl);
            result = this.myProxyAuthentication != null;
        }
        return result;
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/ProxyCallback", "updateParameters"));
        }
        String proxyHostParameter = (String)ContainerUtil.find(command.getParameters(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                return s.contains("http-proxy-port");
            }
        });
        if (!StringUtil.isEmpty((String)proxyHostParameter) && this.myUrl != null && this.myProxyAuthentication != null) {
            String group = ProxyCallback.getHostGroup(proxyHostParameter);
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-username=%s", group, this.myProxyAuthentication.getUserName()));
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-password=%s", group, String.valueOf(this.myProxyAuthentication.getPassword())));
        }
    }

    @NotNull
    private static String getHostGroup(@NotNull String proxyHostParameter) {
        if (proxyHostParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxyHostParameter", "org/jetbrains/idea/svn/commandLine/ProxyCallback", "getHostGroup"));
        }
        int start = proxyHostParameter.indexOf(":");
        int finish = proxyHostParameter.indexOf(":", start + 1);
        String string = proxyHostParameter.substring(start + 1, finish);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/ProxyCallback", "getHostGroup"));
        }
        return string;
    }
}

