/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class SshTunnelRuntimeModule
extends BaseCommandRuntimeModule {
    public static final String DEFAULT_SSH_TUNNEL_VALUE = "$SVN_SSH ssh -q";

    public SshTunnelRuntimeModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runtime", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "<init>"));
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) throws SvnBindException {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "onStart"));
        }
        if (!CommandRuntime.isLocal(command) && !SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG.equals((Object)this.getState().sshConnectionType)) {
            command.put("--config-option", "config:tunnels:ssh=" + StringUtil.notNullize((String)this.buildTunnelValue()));
        }
    }

    @NotNull
    private SvnConfiguration getConfiguration() {
        SvnConfiguration svnConfiguration = this.myRuntime.getVcs().getSvnConfiguration();
        if (svnConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "getConfiguration"));
        }
        return svnConfiguration;
    }

    @NotNull
    private SvnConfigurationState getState() {
        SvnConfigurationState svnConfigurationState = this.getConfiguration().getState();
        if (svnConfigurationState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "getState"));
        }
        return svnConfigurationState;
    }

    @Nullable
    private String buildTunnelValue() {
        String sshPath = this.getState().sshExecutablePath;
        sshPath = !StringUtil.isEmpty((String)sshPath) ? sshPath : SshTunnelRuntimeModule.getExecutablePath(this.getConfiguration().getSshTunnelSetting());
        return StringUtil.join((Collection)CommandLineUtil.toCommandLine((String)sshPath, (List)this.buildTunnelCommandLine(sshPath).getParametersList().getParameters()), (String)" ");
    }

    @NotNull
    private GeneralCommandLine buildTunnelCommandLine(@NotNull String sshPath) {
        if (sshPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sshPath", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "buildTunnelCommandLine"));
        }
        GeneralCommandLine result = new GeneralCommandLine(new String[]{sshPath});
        boolean isPuttyLinkClient = StringUtil.endsWithIgnoreCase((String)FileUtil.getNameWithoutExtension((String)sshPath), (String)"plink");
        SvnConfigurationState state = this.getState();
        if (!isPuttyLinkClient) {
            result.addParameter("-q");
        }
        result.addParameters(new String[]{isPuttyLinkClient ? "-P" : "-p", String.valueOf(state.sshPort)});
        if (!StringUtil.isEmpty((String)state.sshUserName)) {
            result.addParameters(new String[]{"-l", state.sshUserName});
        }
        if (SvnConfiguration.SshConnectionType.PRIVATE_KEY.equals((Object)state.sshConnectionType) && !StringUtil.isEmpty((String)state.sshPrivateKeyPath)) {
            result.addParameters(new String[]{"-i", FileUtil.toSystemIndependentName((String)state.sshPrivateKeyPath)});
        }
        GeneralCommandLine generalCommandLine = result;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "buildTunnelCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    public static String getSshTunnelValue(@Nullable String tunnelSetting) {
        String svnSshVariableName = SshTunnelRuntimeModule.getSvnSshVariableName(tunnelSetting = !StringUtil.isEmpty((String)tunnelSetting) ? tunnelSetting : DEFAULT_SSH_TUNNEL_VALUE);
        String svnSshVariableValue = EnvironmentUtil.getValue((String)svnSshVariableName);
        String string = !StringUtil.isEmpty((String)svnSshVariableValue) ? svnSshVariableValue : (!StringUtil.isEmpty((String)svnSshVariableName) ? tunnelSetting.substring(1 + svnSshVariableName.length()) : tunnelSetting);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "getSshTunnelValue"));
        }
        return string;
    }

    @NotNull
    public static String getSvnSshVariableName(@Nullable String tunnel) {
        String result = "";
        if (tunnel != null && tunnel.startsWith("$")) {
            result = ((String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)tunnel, (String)" "), (Object)tunnel)).substring(1);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "getSvnSshVariableName"));
        }
        return string;
    }

    @NotNull
    public static String getExecutablePath(@Nullable String tunnelSetting) {
        String string = StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)ParametersListUtil.parse((String)SshTunnelRuntimeModule.getSshTunnelValue(tunnelSetting))))).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/commandLine/SshTunnelRuntimeModule", "getExecutablePath"));
        }
        return string;
    }
}

