/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.conflict;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.ConflictAction;
import org.jetbrains.idea.svn.conflict.ConflictOperation;
import org.jetbrains.idea.svn.conflict.ConflictReason;
import org.jetbrains.idea.svn.conflict.ConflictVersion;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;

public class TreeConflictDescription
extends BaseNodeDescription {
    private final File myPath;
    private final ConflictAction myConflictAction;
    private final ConflictReason myConflictReason;
    private final ConflictOperation myOperation;
    private final ConflictVersion mySourceLeftVersion;
    private final ConflictVersion mySourceRightVersion;

    @Nullable
    public static TreeConflictDescription create(@Nullable SVNTreeConflictDescription conflict) {
        TreeConflictDescription result = null;
        if (conflict != null) {
            result = new TreeConflictDescription(conflict.getPath(), NodeKind.from(conflict.getNodeKind()), ConflictAction.from(conflict.getConflictAction().getName()), ConflictReason.from(conflict.getConflictReason().getName()), ConflictOperation.from(conflict.getOperation().getName()), ConflictVersion.create(conflict.getSourceLeftVersion()), ConflictVersion.create(conflict.getSourceRightVersion()));
        }
        return result;
    }

    public TreeConflictDescription(File path, @NotNull NodeKind nodeKind, ConflictAction conflictAction, ConflictReason conflictReason, ConflictOperation operation, ConflictVersion sourceLeftVersion, ConflictVersion sourceRightVersion) {
        if (nodeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeKind", "org/jetbrains/idea/svn/conflict/TreeConflictDescription", "<init>"));
        }
        super(nodeKind);
        this.myPath = path;
        this.myConflictAction = conflictAction;
        this.myConflictReason = conflictReason;
        this.myOperation = operation;
        this.mySourceLeftVersion = sourceLeftVersion;
        this.mySourceRightVersion = sourceRightVersion;
    }

    public boolean isTextConflict() {
        return false;
    }

    public boolean isPropertyConflict() {
        return false;
    }

    public boolean isTreeConflict() {
        return true;
    }

    public File getPath() {
        return this.myPath;
    }

    public ConflictAction getConflictAction() {
        return this.myConflictAction;
    }

    public ConflictReason getConflictReason() {
        return this.myConflictReason;
    }

    @NotNull
    public NodeKind getNodeKind() {
        NodeKind nodeKind = this.myKind;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/TreeConflictDescription", "getNodeKind"));
        }
        return nodeKind;
    }

    public ConflictOperation getOperation() {
        return this.myOperation;
    }

    public ConflictVersion getSourceLeftVersion() {
        return this.mySourceLeftVersion;
    }

    public ConflictVersion getSourceRightVersion() {
        return this.mySourceRightVersion;
    }

    @NotNull
    public String toPresentableString() {
        String string = "local " + (Object)((Object)this.getConflictReason()) + ", incoming " + (Object)((Object)this.getConflictAction()) + " upon " + (Object)((Object)this.getOperation());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/conflict/TreeConflictDescription", "toPresentableString"));
        }
        return string;
    }
}

