/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.trilead.ssh2.crypto.PEMDecoder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil;

public class SSHCredentialsDialog
extends DialogWrapper
implements ActionListener,
DocumentListener {
    private boolean myAllowSave;
    private boolean myIsAgentAllowed;
    private String myUserName;
    private String myRealm;
    private JTextField myUserNameText;
    private JCheckBox myAllowSaveCheckBox;
    private JPasswordField myPasswordText;
    private JPasswordField myPassphraseText;
    private TextFieldWithBrowseButton myKeyFileText;
    private JBRadioButton mySshAgentButton;
    private JRadioButton myPasswordButton;
    private JRadioButton myKeyButton;
    private JLabel myPasswordLabel;
    private JLabel myKeyFileLabel;
    private JLabel myPortLabel;
    private JTextField myPortField;
    private JLabel myPassphraseLabel;
    private final Project myProject;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.authentication";
    private boolean myKeyFileEmptyOrCorrect;

    public SSHCredentialsDialog(Project project, String realm, String userName, boolean allowSave, int port, boolean isAgentAllowed) {
        super(project, true);
        this.myProject = project;
        this.myRealm = realm;
        this.myUserName = userName;
        this.myAllowSave = allowSave;
        this.myIsAgentAllowed = isAgentAllowed;
        this.setResizable(true);
        this.getHelpAction().setEnabled(true);
        this.init();
        this.myPortField.setText("" + port);
        this.myKeyFileEmptyOrCorrect = true;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SSHCredentialsDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 3;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel label = new JLabel(SvnBundle.message("label.ssh.authentication.realm", this.myRealm));
        panel.add((Component)label, gb);
        ++gb.gridy;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        label = new JLabel(SvnBundle.message("label.ssh.user.name", new Object[0]));
        panel.add((Component)label, gb);
        gb.gridx = 1;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myUserNameText = new JTextField();
        panel.add((Component)this.myUserNameText, gb);
        label.setLabelFor(this.myUserNameText);
        if (this.myUserName != null) {
            this.myUserNameText.setText(this.myUserName);
        }
        this.myUserNameText.selectAll();
        this.myUserNameText.getDocument().addDocumentListener(this);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 3;
        this.mySshAgentButton = new JBRadioButton(SvnBundle.message("radio.ssh.authentication.with.agent", new Object[0]));
        panel.add((Component)this.mySshAgentButton, gb);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 3;
        this.myPasswordButton = new JRadioButton(SvnBundle.message("radio.ssh.authentication.with.password", new Object[0]));
        panel.add((Component)this.myPasswordButton, gb);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPasswordLabel = new JLabel(SvnBundle.message("label.ssh.password", new Object[0]));
        panel.add((Component)this.myPasswordLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myPasswordText = new JPasswordField();
        panel.add((Component)this.myPasswordText, gb);
        this.myPasswordLabel.setLabelFor(this.myPasswordText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 3;
        this.myKeyButton = new JRadioButton(SvnBundle.message("radio.ssh.authentication.private.key", new Object[0]));
        panel.add((Component)this.myKeyButton, gb);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myKeyFileLabel = new JLabel(SvnBundle.message("label.ssh.key.file", new Object[0]));
        panel.add((Component)this.myKeyFileLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myKeyFileText = new TextFieldWithBrowseButton((ActionListener)this);
        this.myKeyFileText.setEditable(false);
        panel.add((Component)this.myKeyFileText, gb);
        this.myKeyFileLabel.setLabelFor((Component)this.myKeyFileText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPassphraseLabel = new JLabel(SvnBundle.message("label.ssh.passphrase", new Object[0]));
        panel.add((Component)this.myPassphraseLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myPassphraseText = new JPasswordField(30);
        panel.add((Component)this.myPassphraseText, gb);
        this.myPassphraseText.getDocument().addDocumentListener(this);
        this.myPassphraseText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SSHCredentialsDialog.this.checkKeyFile();
                SSHCredentialsDialog.this.updateOKButton();
            }
        });
        this.myPassphraseLabel.setLabelFor(this.myPassphraseText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPortLabel = new JLabel(SvnBundle.message("label.ssh.port", new Object[0]));
        panel.add((Component)this.myPortLabel, gb);
        gb.gridx = 1;
        gb.weightx = 0.0;
        gb.gridwidth = 2;
        gb.fill = 0;
        this.myPortField = new JTextField();
        this.myPortField.setColumns(6);
        panel.add((Component)this.myPortField, gb);
        this.myPortLabel.setLabelFor(this.myPortField);
        this.myPortField.setText("22");
        this.myPortField.setMinimumSize(this.myPortField.getPreferredSize());
        this.myPortField.getDocument().addDocumentListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.mySshAgentButton);
        group.add(this.myPasswordButton);
        group.add(this.myKeyButton);
        this.mySshAgentButton.setEnabled(this.myIsAgentAllowed);
        group.setSelected(((AbstractButton)(this.myIsAgentAllowed ? this.mySshAgentButton : this.myPasswordButton)).getModel(), true);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 3;
        gb.weightx = 1.0;
        gb.anchor = 17;
        gb.fill = 2;
        this.myAllowSaveCheckBox = new JCheckBox(SvnBundle.message("checkbox.ssh.keep.for.current.session", new Object[0]));
        panel.add((Component)this.myAllowSaveCheckBox, gb);
        if (!this.myAllowSave) {
            ++gb.gridy;
            JLabel cannotSaveLabel = new JLabel(SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]));
            cannotSaveLabel.setForeground(UIUtil.getInactiveTextColor());
            panel.add((Component)cannotSaveLabel, gb);
        }
        ++gb.gridy;
        panel.add((Component)new JSeparator(), gb);
        ++gb.gridy;
        gb.weighty = 1.0;
        panel.add((Component)new JLabel(), gb);
        this.myAllowSaveCheckBox.setSelected(false);
        this.myAllowSaveCheckBox.setEnabled(this.myAllowSave);
        this.mySshAgentButton.addActionListener((ActionListener)this);
        this.myKeyButton.addActionListener(this);
        this.myPasswordButton.addActionListener(this);
        this.updateFields();
        this.updateOKButton();
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserNameText;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    protected String getDimensionServiceKey() {
        return "svn.sshPasswordDialog";
    }

    public boolean isOKActionEnabled() {
        boolean ok;
        boolean bl = ok = this.myUserNameText != null && this.myUserNameText.getText().trim().length() > 0;
        if (ok) {
            if (this.myPasswordButton.isSelected()) {
                ok = this.myPasswordText != null && this.myPasswordText.getPassword() != null;
            } else if (this.myKeyButton.isSelected()) {
                if (!this.myKeyFileEmptyOrCorrect) {
                    return false;
                }
                ok = this.myKeyFileText != null && this.myKeyFileText.getText().trim().length() > 0;
            } else {
                ok = this.mySshAgentButton.isSelected();
            }
            if (ok) {
                String portNumber = this.myPortField.getText();
                try {
                    int port = Integer.parseInt(portNumber);
                    ok = port > 0;
                }
                catch (NumberFormatException nfe) {
                    ok = false;
                }
            }
        }
        return ok;
    }

    public boolean isSshAgentSelected() {
        return this.mySshAgentButton.isSelected();
    }

    public String getUserName() {
        return this.isOK() && this.myUserNameText != null ? this.myUserNameText.getText() : null;
    }

    public String getKeyFile() {
        if (this.myKeyFileText.isEnabled()) {
            return this.myKeyFileText.getText();
        }
        return null;
    }

    public int getPortNumber() {
        String portNumber = this.myPortField.getText();
        int port = 22;
        try {
            port = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        if (port <= 0) {
            port = 22;
        }
        return port;
    }

    public String getPassphrase() {
        char[] pwd;
        if (this.myPassphraseText == null || !this.myPassphraseText.isEnabled()) {
            return null;
        }
        if (this.isOK() && (pwd = this.myPassphraseText.getPassword()) != null) {
            return new String(pwd);
        }
        return null;
    }

    public String getPassword() {
        char[] pwd;
        if (this.myPasswordText != null && !this.myPasswordText.isEnabled()) {
            return null;
        }
        if (this.isOK() && this.myPasswordText != null && (pwd = this.myPasswordText.getPassword()) != null) {
            return new String(pwd);
        }
        return null;
    }

    public boolean isSaveAllowed() {
        return this.isOK() && this.myAllowSave && this.myAllowSaveCheckBox != null && this.myAllowSaveCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myPasswordButton || e.getSource() == this.myKeyButton || e.getSource() == this.mySshAgentButton) {
            this.updateFields();
            this.checkKeyFile();
            this.updateOKButton();
        } else {
            VirtualFile file;
            final String[] path = new String[]{this.myKeyFileText.getText()};
            if (path[0] != null && path[0].trim().length() > 0) {
                path[0] = "file://" + path[0].replace(File.separatorChar, '/');
                file = VirtualFileManager.getInstance().findFileByUrl(path[0]);
            } else {
                path[0] = "file://" + SystemProperties.getUserHome() + "/.ssh/identity";
                path[0] = path[0].replace(File.separatorChar, '/');
                file = VirtualFileManager.getInstance().findFileByUrl(path[0]);
                if (file == null || !file.exists()) {
                    path[0] = "file://" + SystemProperties.getUserHome() + "/.ssh";
                    file = VirtualFileManager.getInstance().findFileByUrl(path[0]);
                }
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(SvnBundle.message("dialog.title.openssh.v2.private.key", new Object[0])).withDescription(SvnBundle.message("dialog.description.openssh.v2.private.key", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)file, (Consumer)new Consumer<List<VirtualFile>>(){

                public void consume(List<VirtualFile> files) {
                    if (files.size() == 1) {
                        path[0] = FileUtil.toSystemDependentName((String)files.get(0).getPath());
                        SSHCredentialsDialog.this.myKeyFileText.setText(path[0]);
                    }
                    SSHCredentialsDialog.this.checkKeyFile();
                    SSHCredentialsDialog.this.updateOKButton();
                }
            });
        }
    }

    private void checkKeyFile() {
        this.myKeyFileEmptyOrCorrect = true;
        this.setErrorText(null);
        if (!this.myKeyButton.isSelected()) {
            return;
        }
        String text = this.myKeyFileText.getText();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return;
        }
        File file = new File(text);
        if (!file.exists()) {
            this.setErrorText("Private key file does not exist");
            this.myKeyFileEmptyOrCorrect = false;
            return;
        }
        char[] password = this.myPassphraseText.getPassword();
        try {
            PEMDecoder.decode((char[])SVNSSHPrivateKeyUtil.readPrivateKey((File)file), (String)String.valueOf(password));
        }
        catch (IOException e) {
            this.setErrorText("Private key file is not valid. " + e.getMessage());
            this.myKeyFileEmptyOrCorrect = false;
        }
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    private void updateFields() {
        this.myPasswordText.setEnabled(this.myPasswordButton.isSelected());
        this.myPasswordLabel.setEnabled(this.myPasswordButton.isSelected());
        this.myKeyFileText.setEnabled(this.myKeyButton.isSelected());
        this.myKeyFileLabel.setEnabled(this.myKeyButton.isSelected());
        this.myPassphraseLabel.setEnabled(this.myKeyButton.isSelected());
        this.myPassphraseText.setEnabled(this.myKeyButton.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    protected void doOKAction() {
        this.checkKeyFile();
        this.updateOKButton();
        if (!this.isOKActionEnabled()) {
            return;
        }
        super.doOKAction();
    }
}

