/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class WcInfoLoader {
    @NotNull
    private final SvnVcs myVcs;
    @Nullable
    private final RepositoryLocation myLocation;

    public WcInfoLoader(@NotNull SvnVcs vcs, @Nullable RepositoryLocation location) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/history/WcInfoLoader", "<init>"));
        }
        this.myVcs = vcs;
        this.myLocation = location;
    }

    @NotNull
    public List<WCInfoWithBranches> loadRoots() {
        ArrayList result = ContainerUtil.newArrayList();
        for (WCInfo info : this.myVcs.getAllWcInfos()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)this.createInfo(info));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/WcInfoLoader", "loadRoots"));
        }
        return arrayList;
    }

    @Nullable
    public WCInfoWithBranches reloadInfo(@NotNull WCInfoWithBranches info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/history/WcInfoLoader", "reloadInfo"));
        }
        File file = info.getRootInfo().getIoFile();
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(file);
        return rootInfo != null ? this.createInfo(new WCInfo(rootInfo, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this.myVcs, file))) : null;
    }

    @Nullable
    private WCInfoWithBranches createInfo(@NotNull WCInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/history/WcInfoLoader", "createInfo"));
        }
        if (!info.getFormat().supportsMergeInfo()) {
            return null;
        }
        String url = info.getUrl().toString();
        if (this.myLocation != null && !this.myLocation.toPresentableString().startsWith(url) && !url.startsWith(this.myLocation.toPresentableString())) {
            return null;
        }
        if (!SvnUtil.checkRepositoryVersion15(this.myVcs, url)) {
            return null;
        }
        RootUrlInfo rootForUrl = this.myVcs.getSvnFileUrlMapping().getWcRootForUrl(url);
        return rootForUrl != null ? this.createInfoWithBranches(info, rootForUrl) : null;
    }

    @NotNull
    private WCInfoWithBranches createInfoWithBranches(@NotNull WCInfo info, @NotNull RootUrlInfo rootUrlInfo) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/history/WcInfoLoader", "createInfoWithBranches"));
        }
        if (rootUrlInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootUrlInfo", "org/jetbrains/idea/svn/history/WcInfoLoader", "createInfoWithBranches"));
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject()).get(rootUrlInfo.getVirtualFile());
        Ref workingCopyBranch = Ref.create();
        ArrayList branches = ContainerUtil.newArrayList();
        String url = info.getUrl().toString();
        String trunkUrl = configuration.getTrunkUrl();
        if (trunkUrl != null) {
            WcInfoLoader.add(url, trunkUrl, branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
        }
        for (String branchUrl : configuration.getBranchUrls()) {
            for (SvnBranchItem branchItem : configuration.getBranches(branchUrl)) {
                WcInfoLoader.add(url, branchItem.getUrl(), branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
            }
        }
        Collections.sort(branches, new Comparator<WCInfoWithBranches.Branch>(){

            @Override
            public int compare(WCInfoWithBranches.Branch o1, WCInfoWithBranches.Branch o2) {
                return Comparing.compare((Comparable)((Object)o1.getUrl()), (Comparable)((Object)o2.getUrl()));
            }
        });
        WCInfoWithBranches wCInfoWithBranches = new WCInfoWithBranches(info, branches, rootUrlInfo.getRoot(), (WCInfoWithBranches.Branch)workingCopyBranch.get());
        if (wCInfoWithBranches == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/WcInfoLoader", "createInfoWithBranches"));
        }
        return wCInfoWithBranches;
    }

    private static void add(@NotNull String url, @NotNull String branchUrl, @NotNull List<WCInfoWithBranches.Branch> branches, @NotNull Ref<WCInfoWithBranches.Branch> workingCopyBranch) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/history/WcInfoLoader", "add"));
        }
        if (branchUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrl", "org/jetbrains/idea/svn/history/WcInfoLoader", "add"));
        }
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "org/jetbrains/idea/svn/history/WcInfoLoader", "add"));
        }
        if (workingCopyBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyBranch", "org/jetbrains/idea/svn/history/WcInfoLoader", "add"));
        }
        WCInfoWithBranches.Branch branch = new WCInfoWithBranches.Branch(branchUrl);
        if (!SVNPathUtil.isAncestor((String)branchUrl, (String)url)) {
            branches.add(branch);
        } else {
            workingCopyBranch.set((Object)branch);
        }
    }
}

