/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.OneShotMergeInfoHelper;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class MergeCalculatorTask
extends BaseMergeTask
implements Consumer<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> {
    @NotNull
    private final AtomicReference<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> myCopyData;
    @NotNull
    private final String myMergeTitle;
    @NotNull
    private final MergeChecker myMergeChecker;

    public void consume(TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException> value) {
        this.myCopyData.set(value);
    }

    public MergeCalculatorTask(@NotNull MergeContext mergeContext, @NotNull QuickMergeInteraction interaction) throws VcsException {
        if (mergeContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeContext", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        if (interaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interaction", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "<init>"));
        }
        super(mergeContext, interaction, "Calculating not merged revisions", Where.POOLED);
        this.myMergeTitle = "Merge from " + this.myMergeContext.getBranchName();
        this.myMergeChecker = new OneShotMergeInfoHelper(this.myMergeContext);
        ((OneShotMergeInfoHelper)this.myMergeChecker).prepare();
        this.myCopyData = new AtomicReference();
    }

    public void run(ContinuationContext context) {
        SvnBranchPointsCalculator.WrapperInvertor copyPoint = this.getCopyPoint(context);
        if (copyPoint != null && this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo()) {
            LinkedList<Pair<SvnChangeList, LogHierarchyNode>> afterCopyPointChangeLists = this.getChangeListsAfter(context, copyPoint.getTrue().getTargetRevision());
            List<CommittedChangeList> notMergedChangeLists = this.getNotMergedChangeLists(afterCopyPointChangeLists);
            if (!notMergedChangeLists.isEmpty()) {
                context.next(new TaskDescriptor[]{new ShowRevisionSelector(copyPoint, notMergedChangeLists)});
            } else {
                this.finishWithError(context, "Everything is up-to-date", false);
            }
        }
    }

    @Nullable
    private SvnBranchPointsCalculator.WrapperInvertor getCopyPoint(@NotNull ContinuationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getCopyPoint"));
        }
        SvnBranchPointsCalculator.WrapperInvertor result = null;
        try {
            result = (SvnBranchPointsCalculator.WrapperInvertor)this.myCopyData.get().get();
            if (result == null) {
                this.finishWithError(context, "Merge start wasn't found", true);
            }
        }
        catch (VcsException e) {
            this.finishWithError(context, "Merge start wasn't found", Collections.singletonList(e));
        }
        return result;
    }

    @NotNull
    private LinkedList<Pair<SvnChangeList, LogHierarchyNode>> getChangeListsAfter(@NotNull ContinuationContext context, final long revision) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeListsAfter"));
        }
        ChangeBrowserSettings settings = new ChangeBrowserSettings();
        settings.CHANGE_AFTER = Long.toString(revision);
        settings.USE_CHANGE_AFTER_FILTER = true;
        final LinkedList result = ContainerUtil.newLinkedList();
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        try {
            ((SvnCommittedChangesProvider)this.myMergeContext.getVcs().getCommittedChangesProvider()).getCommittedChangesWithMergedRevisons(settings, new SvnRepositoryLocation(this.myMergeContext.getSourceUrl()), 0, new PairConsumer<SvnChangeList, LogHierarchyNode>(){

                public void consume(@NotNull SvnChangeList changeList, LogHierarchyNode tree) {
                    if (changeList == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$1", "consume"));
                    }
                    indicator.checkCanceled();
                    if (revision < changeList.getNumber()) {
                        result.add(Pair.create((Object)changeList, (Object)tree));
                    }
                }
            });
        }
        catch (VcsException e) {
            this.finishWithError(context, "Checking revisions for merge fault", Collections.singletonList(e));
        }
        LinkedList linkedList = result;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getChangeListsAfter"));
        }
        return linkedList;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        ProgressManager.getInstance().getProgressIndicator().setText("Checking merge information...");
        String repositoryRelativeWorkingCopyRoot = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getWcInfo().getRootUrl()));
        String repositoryRelativeSourceBranch = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myMergeContext.getWcInfo().getRepositoryRoot(), (String)this.myMergeContext.getSourceUrl()));
        List<CommittedChangeList> list = this.getNotMergedChangeLists(changeLists, repositoryRelativeWorkingCopyRoot, repositoryRelativeSourceBranch);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        return list;
    }

    @NotNull
    private List<CommittedChangeList> getNotMergedChangeLists(@NotNull List<Pair<SvnChangeList, LogHierarchyNode>> changeLists, @NotNull String workingCopyRoot, @NotNull String sourceBranch) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        if (workingCopyRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRoot", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Pair<SvnChangeList, LogHierarchyNode> pair : changeLists) {
            SvnChangeList changeList = (SvnChangeList)pair.getFirst();
            ProgressManager.getInstance().getProgressIndicator().setText2("Processing revision " + changeList.getNumber());
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_MERGED.equals((Object)this.myMergeChecker.checkList(changeList)) || MergeCalculatorTask.checkListForPaths(workingCopyRoot, sourceBranch, (LogHierarchyNode)pair.getSecond())) continue;
            result.add(changeList);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "getNotMergedChangeLists"));
        }
        return arrayList;
    }

    static boolean checkListForPaths(final @NotNull String workingCopyRoot, final @NotNull String sourceBranch, @NotNull LogHierarchyNode node) {
        if (workingCopyRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingCopyRoot", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        if (sourceBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkListForPaths"));
        }
        boolean isLocalChange = ContainerUtil.or(node.getChildren(), (Condition)new Condition<LogHierarchyNode>(){

            public boolean value(@NotNull LogHierarchyNode child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$2", "value"));
                }
                return MergeCalculatorTask.checkForSubtree(child, workingCopyRoot, sourceBranch);
            }
        });
        return isLocalChange || MergeCalculatorTask.checkForEntry(node.getMe(), workingCopyRoot, sourceBranch);
    }

    private static boolean checkForSubtree(@NotNull LogHierarchyNode tree, @NotNull String relativeBranch, @NotNull String localURL) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        if (relativeBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        if (localURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localURL", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForSubtree"));
        }
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (MergeCalculatorTask.checkForEntry(element.getMe(), localURL, relativeBranch)) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        if (localURL == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localURL", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        if (relativeBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeBranch", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask", "checkForEntry"));
        }
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (SVNPathUtil.isAncestor((String)localURL, (String)path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !SVNPathUtil.isAncestor((String)relativeBranch, (String)path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private class ShowRevisionSelector
    extends TaskDescriptor {
        @NotNull
        private final List<CommittedChangeList> myChangeLists;
        @NotNull
        private final SvnBranchPointsCalculator.WrapperInvertor myCopyPoint;

        private ShowRevisionSelector(@NotNull SvnBranchPointsCalculator.WrapperInvertor copyPoint, List<CommittedChangeList> changeLists) {
            if (copyPoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyPoint", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$ShowRevisionSelector", "<init>"));
            }
            if (changeLists == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "org/jetbrains/idea/svn/integrate/MergeCalculatorTask$ShowRevisionSelector", "<init>"));
            }
            super("show revisions to merge", Where.AWT);
            this.myCopyPoint = copyPoint;
            this.myChangeLists = changeLists;
        }

        public void run(ContinuationContext context) {
            QuickMergeInteraction.SelectMergeItemsResult result = MergeCalculatorTask.this.myInteraction.selectMergeItems(this.myChangeLists, MergeCalculatorTask.this.myMergeTitle, MergeCalculatorTask.this.myMergeChecker);
            switch (result.getResultCode()) {
                case cancel: {
                    context.cancelEverything();
                    break;
                }
                case all: {
                    context.next(MergeCalculatorTask.this.getMergeAllTasks());
                    break;
                }
                default: {
                    List<CommittedChangeList> lists = result.getSelectedLists();
                    if (lists.isEmpty()) break;
                    MergeCalculatorTask.this.runChangeListsMerge(context, lists, this.myCopyPoint, MergeCalculatorTask.this.myMergeTitle);
                }
            }
        }
    }
}

