/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public enum StatusType {
    UNUSED("unused"),
    INAPPLICABLE("inapplicable"),
    UNKNOWN("unknown"),
    UNCHANGED("unchanged"),
    MISSING("missing"),
    OBSTRUCTED("obstructed"),
    CHANGED("changed"),
    MERGED("merged"),
    CONFLICTED("conflicted"),
    STATUS_NONE("none"),
    STATUS_NORMAL("normal", ' '),
    STATUS_MODIFIED("modified", 'M'),
    STATUS_ADDED("added", 'A'),
    STATUS_DELETED("deleted", 'D'),
    STATUS_UNVERSIONED("unversioned", '?'),
    STATUS_MISSING("missing", '!'),
    STATUS_REPLACED("replaced", 'R'),
    STATUS_CONFLICTED("conflicted", 'C'),
    STATUS_OBSTRUCTED("obstructed", '~'),
    STATUS_IGNORED("ignored", 'I'),
    STATUS_INCOMPLETE("incomplete", '!'),
    STATUS_EXTERNAL("external", 'X');

    private static final String STATUS_PREFIX = "STATUS_";
    @NotNull
    private static final Map<String, StatusType> ourOtherStatusTypes;
    @NotNull
    private static final Map<String, StatusType> ourStatusTypesForStatusOperation;
    private String myName;
    private char myCode;

    private StatusType(String name) {
        this(name, ' ');
    }

    private StatusType(String name, char code) {
        this.myName = name;
        this.myCode = code;
    }

    public char getCode() {
        return this.myCode;
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull StatusType action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/jetbrains/idea/svn/status/StatusType", "register"));
        }
        (action.name().startsWith(STATUS_PREFIX) ? ourStatusTypesForStatusOperation : ourOtherStatusTypes).put(action.myName, action);
    }

    @NotNull
    public static StatusType from(@NotNull SVNStatusType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/status/StatusType", "from"));
        }
        StatusType result = ourOtherStatusTypes.get(type.toString());
        if (type != SVNStatusType.CONFLICTED && type != SVNStatusType.OBSTRUCTED && type != SVNStatusType.MISSING) {
            result = (StatusType)((Object)ObjectUtils.chooseNotNull((Object)((Object)ourStatusTypesForStatusOperation.get(type.toString())), (Object)((Object)result)));
        }
        StatusType statusType = (StatusType)((Object)ObjectUtils.notNull((Object)((Object)result), (Object)((Object)UNUSED)));
        if (statusType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/status/StatusType", "from"));
        }
        return statusType;
    }

    @Nullable
    public static StatusType forStatusOperation(@NotNull String statusName) {
        if (statusName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusName", "org/jetbrains/idea/svn/status/StatusType", "forStatusOperation"));
        }
        return ourStatusTypesForStatusOperation.get(statusName);
    }

    static {
        ourOtherStatusTypes = ContainerUtil.newHashMap();
        ourStatusTypesForStatusOperation = ContainerUtil.newHashMap();
        for (StatusType action : StatusType.values()) {
            StatusType.register(action);
        }
    }
}

