/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgCommandResultHandler;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgPatchReferenceValidator;

public class HgQRenameCommand {
    private static final Logger LOG = Logger.getInstance(HgQRenameCommand.class);
    @NotNull
    private final HgRepository myRepository;

    public HgQRenameCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQRenameCommand", "<init>"));
        }
        this.myRepository = repository;
    }

    public void execute(final @NotNull Hash patchHash) {
        if (patchHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchHash", "org/zmlx/hg4idea/command/mq/HgQRenameCommand", "execute"));
        }
        Project project = this.myRepository.getProject();
        HgNameWithHashInfo patchInfo = (HgNameWithHashInfo)ContainerUtil.find(this.myRepository.getMQAppliedPatches(), (Condition)new Condition<HgNameWithHashInfo>(){

            public boolean value(HgNameWithHashInfo info) {
                return info.getHash().equals(patchHash);
            }
        });
        if (patchInfo == null) {
            LOG.error("Could not find patch " + patchHash.toString());
            return;
        }
        String oldName = patchInfo.getName();
        String newName = Messages.showInputDialog((Project)project, (String)String.format("Enter a new name for %s patch:", oldName), (String)"Rename Patch", (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new HgPatchReferenceValidator(this.myRepository));
        if (newName != null) {
            HgQRenameCommand.performPatchRename(this.myRepository, oldName, newName);
        }
    }

    public static void performPatchRename(final @NotNull HgRepository repository, final @NotNull String oldName, final @NotNull String newName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQRenameCommand", "performPatchRename"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "org/zmlx/hg4idea/command/mq/HgQRenameCommand", "performPatchRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "org/zmlx/hg4idea/command/mq/HgQRenameCommand", "performPatchRename"));
        }
        if (oldName.equals(newName)) {
            return;
        }
        final Project project = repository.getProject();
        new HgCommandExecutor(project).execute(repository.getRoot(), "qrename", Arrays.asList(oldName, newName), new HgCommandResultHandler(){

            @Override
            public void process(@Nullable HgCommandResult result) {
                if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
                    new HgCommandResultNotifier(project).notifyError(result, "Qrename command failed", "Could not rename patch " + oldName + " to " + newName);
                }
                repository.update();
            }
        });
    }
}

