/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMAssetIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.util.FileWatcher;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javafx.application.Platform;

class WatchingController
implements FileWatcher.Delegate {
    private final EditorController editorController;
    private final FileWatcher fileWatcher = new FileWatcher(2000L, this, EditorController.class.getSimpleName());

    public WatchingController(EditorController editorController) {
        this.editorController = editorController;
    }

    public void fxomDocumentDidChange() {
        this.updateFileWatcher();
    }

    public void jobManagerRevisionDidChange() {
        this.updateFileWatcher();
    }

    public void start() {
        this.fileWatcher.start();
    }

    public void stop() {
        this.fileWatcher.stop();
    }

    public boolean isStarted() {
        return this.fileWatcher.isStarted();
    }

    @Override
    public void fileWatcherDidWatchTargetCreation(Path target) {
        assert (Platform.isFxApplicationThread());
        this.updateEditorController("file.watching.file.created", target);
    }

    @Override
    public void fileWatcherDidWatchTargetDeletion(Path target) {
        assert (Platform.isFxApplicationThread());
        this.updateEditorController("file.watching.file.deleted", target);
    }

    @Override
    public void fileWatcherDidWatchTargetModification(Path target) {
        assert (Platform.isFxApplicationThread());
        this.updateEditorController("file.watching.file.modified", target);
    }

    private void updateFileWatcher() {
        Collection<Path> targets;
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        if (fxomDocument == null) {
            targets = Collections.emptyList();
        } else {
            FXOMAssetIndex assetIndex = new FXOMAssetIndex(fxomDocument);
            targets = assetIndex.getFileAssets().keySet();
        }
        this.fileWatcher.setTargets(targets);
    }

    private void updateEditorController(String messageKey, Path target) {
        String targetFileName = target.getFileName().toString();
        this.editorController.getMessageLog().logInfoMessage(messageKey, targetFileName);
        this.editorController.getErrorReport().forget();
        if (targetFileName.toLowerCase(Locale.ROOT).endsWith(".css")) {
            this.editorController.getErrorReport().cssFileDidChange(target);
            this.editorController.getFxomDocument().reapplyCSS(target);
        } else {
            this.editorController.getFxomDocument().refreshSceneGraph();
        }
    }
}

