/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteGridSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;

public class DeleteSelectionJob
extends Job {
    private Job subJob;

    public DeleteSelectionJob(EditorController editorController) {
        super(editorController);
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        this.subJob.execute();
    }

    @Override
    public void undo() {
        this.subJob.undo();
    }

    @Override
    public void redo() {
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        return this.subJob.getDescription();
    }

    Job getSubJob() {
        return this.subJob;
    }

    private void buildSubJobs() {
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            this.subJob = new DeleteObjectSelectionJob(this.getEditorController());
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            this.subJob = new DeleteGridSelectionJob(this.getEditorController());
        } else assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
    }
}

