/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.atomic;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;

public class BackupSelectionJob
extends Job {
    private final AbstractSelectionGroup oldSelectionGroup;

    public BackupSelectionJob(EditorController editorController) {
        super(editorController);
        Selection selection = this.getEditorController().getSelection();
        try {
            this.oldSelectionGroup = selection.getGroup() == null ? null : selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Bug", x);
        }
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        Selection selection = this.getEditorController().getSelection();
        selection.select(this.oldSelectionGroup);
        assert (selection.isValid(this.getEditorController().getFxomDocument()));
    }

    @Override
    public void redo() {
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

