/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.scene.layout.GridPane;

public class GridPaneJobUtils {
    static List<FXOMObject> getTargetGridPanes(EditorController editorController) {
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        assert (asg instanceof ObjectSelectionGroup || asg instanceof GridSelectionGroup);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            result.addAll(osg.getItems());
        } else if (asg instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            result.add(gsg.getParentObject());
        }
        return result;
    }

    static List<Integer> getIndexes(int fromIndex, int toIndex) {
        assert (fromIndex <= toIndex);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = fromIndex;
        while (index <= toIndex) {
            result.add(index++);
        }
        return result;
    }

    static Set<Integer> getAddedIndexes(Set<Integer> targetIndexes, Position position) {
        HashSet<Integer> result = new HashSet<Integer>();
        int shiftIndex = 0;
        for (int targetIndex : targetIndexes) {
            int addedIndex = targetIndex + shiftIndex++;
            if (position == Position.BELOW || position == Position.AFTER) {
                ++addedIndex;
            }
            result.add(addedIndex);
        }
        return result;
    }

    static boolean canPerformAdd(EditorController editorController) {
        boolean result;
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        if (asg instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            result = true;
            for (FXOMObject obj : osg.getItems()) {
                if (obj.getSceneGraphObject() instanceof GridPane) continue;
                result = false;
                break;
            }
        } else {
            result = asg instanceof GridSelectionGroup;
        }
        return result;
    }

    static boolean canPerformRemove(EditorController editorController) {
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        return asg instanceof GridSelectionGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean canPerformMove(EditorController editorController, Position position) {
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof GridSelectionGroup)) return false;
        GridSelectionGroup gsg = (GridSelectionGroup)asg;
        FXOMObject gridPane = gsg.getParentObject();
        GridSelectionGroup.Type type = gsg.getType();
        DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
        switch (type) {
            case COLUMN: {
                int index;
                boolean result;
                if (position == Position.BEFORE) {
                    int index2;
                    result = true;
                    Iterator<Integer> iterator = gsg.getIndexes().iterator();
                    do {
                        if (!iterator.hasNext()) return result;
                    } while ((index2 = iterator.next().intValue()) != 0);
                    return false;
                }
                if (position != Position.AFTER) return false;
                result = true;
                Iterator<Integer> iterator = gsg.getIndexes().iterator();
                do {
                    if (!iterator.hasNext()) return result;
                } while ((index = iterator.next().intValue()) != mask.getColumnsSize() - 1);
                return false;
            }
            case ROW: {
                int index;
                boolean result;
                if (position == Position.ABOVE) {
                    int index3;
                    result = true;
                    Iterator<Integer> iterator = gsg.getIndexes().iterator();
                    do {
                        if (!iterator.hasNext()) return result;
                    } while ((index3 = iterator.next().intValue()) != 0);
                    return false;
                }
                if (position != Position.BELOW) return false;
                result = true;
                Iterator<Integer> iterator = gsg.getIndexes().iterator();
                do {
                    if (!iterator.hasNext()) return result;
                } while ((index = iterator.next().intValue()) != mask.getRowsSize() - 1);
                return false;
            }
            default: {
                boolean result = false;
                assert (false);
                return result;
            }
        }
    }

    public static enum Position {
        ABOVE,
        BELOW,
        BEFORE,
        AFTER;

    }
}

