/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.reference;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.InlineDocumentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemoveObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ReplaceObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.LinkedList;
import java.util.List;

public class CombineIntrinsicReferenceJob
extends InlineDocumentJob {
    private final FXOMIntrinsic reference;

    public CombineIntrinsicReferenceJob(FXOMIntrinsic reference, EditorController editorController) {
        super(editorController);
        assert (reference != null);
        assert (reference.getFxomDocument() == editorController.getFxomDocument());
        this.reference = reference;
    }

    @Override
    protected List<Job> makeAndExecuteSubJobs() {
        LinkedList<Job> result = new LinkedList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        String fxId = FXOMNodes.extractReferenceSource(this.reference);
        FXOMObject referee = fxomDocument.searchWithFxId(fxId);
        RemoveObjectJob removeJob = new RemoveObjectJob(referee, this.getEditorController());
        ((Job)removeJob).execute();
        result.add(removeJob);
        ReplaceObjectJob replaceJob = new ReplaceObjectJob(this.reference, referee, this.getEditorController());
        ((Job)replaceJob).execute();
        result.add(replaceJob);
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isExecutable() {
        return !(this.reference.getType() != FXOMIntrinsic.Type.FX_COPY && this.reference.getType() != FXOMIntrinsic.Type.FX_REFERENCE || this.reference.getParentProperty() == null && this.reference.getParentCollection() == null);
    }
}

