/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.RemovePropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;

public class UnwrapJob
extends BatchSelectionJob {
    private FXOMInstance oldContainer;
    private FXOMInstance newContainer;
    private List<FXOMObject> oldContainerChildren;

    public UnwrapJob(EditorController editorController) {
        super(editorController);
    }

    protected boolean canUnwrap() {
        Selection selection = this.getEditorController().getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (osg.getItems().size() != 1) {
            return false;
        }
        FXOMObject container = osg.getItems().iterator().next();
        if (!(container instanceof FXOMInstance)) {
            return false;
        }
        FXOMInstance containerInstance = (FXOMInstance)container;
        if (container.getSceneGraphObject() == null) {
            return false;
        }
        boolean isAssignableFrom = false;
        for (Class<? extends Parent> clazz : EditorController.getClassesSupportingWrapping()) {
            isAssignableFrom |= clazz.isAssignableFrom(containerInstance.getDeclaredClass());
        }
        if (!isAssignableFrom) {
            return false;
        }
        int childrenCount = this.getChildren(containerInstance).size();
        if (childrenCount == 0) {
            return false;
        }
        FXOMObject parentContainer = container.getParentObject();
        if (parentContainer == null) {
            return childrenCount == 1;
        }
        DesignHierarchyMask parentContainerMask = new DesignHierarchyMask(parentContainer);
        if (parentContainerMask.isAcceptingSubComponent()) {
            return childrenCount >= 1;
        }
        assert (parentContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) || parentContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC) || parentContainerMask.getFxomObject().getSceneGraphObject() instanceof BorderPane || parentContainerMask.getFxomObject().getSceneGraphObject() instanceof DialogPane);
        return childrenCount == 1;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.canUnwrap()) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            assert (osg.getItems().size() == 1);
            this.oldContainer = (FXOMInstance)osg.getItems().iterator().next();
            this.oldContainerChildren = this.getChildren(this.oldContainer);
            PropertyName oldContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.oldContainer, this.oldContainerChildren);
            FXOMPropertyC oldContainerProperty = (FXOMPropertyC)this.oldContainer.getProperties().get(oldContainerPropertyName);
            assert (oldContainerProperty != null && oldContainerProperty.getParentInstance() != null);
            this.newContainer = (FXOMInstance)this.oldContainer.getParentObject();
            RemovePropertyJob removePropertyJob = new RemovePropertyJob(oldContainerProperty, this.getEditorController());
            result.add(removePropertyJob);
            List<Job> removeChildrenJobs = this.removeChildrenJobs(oldContainerProperty, this.oldContainerChildren);
            result.addAll(removeChildrenJobs);
            if (this.newContainer != null) {
                ArrayList<FXOMObject> newContainerChildren = new ArrayList<FXOMObject>();
                newContainerChildren.add(this.oldContainer);
                PropertyName newContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.newContainer, newContainerChildren);
                FXOMPropertyC newContainerProperty = (FXOMPropertyC)this.newContainer.getProperties().get(newContainerPropertyName);
                assert (newContainerProperty != null && newContainerProperty.getParentInstance() != null);
                result.addAll(this.modifyChildrenJobs(this.oldContainerChildren));
                int index = this.oldContainer.getIndexInParentProperty();
                List<Job> addChildrenJobs = this.addChildrenJobs(newContainerProperty, index, this.oldContainerChildren);
                result.addAll(addChildrenJobs);
                RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(this.oldContainer, this.getEditorController());
                result.add(removeValueJob);
            } else {
                assert (this.oldContainerChildren.size() == 1);
                boolean isFxRoot = this.oldContainer.isFxRoot();
                String fxController = this.oldContainer.getFxController();
                if (isFxRoot) {
                    ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                    result.add(fxRootJob);
                }
                if (fxController != null) {
                    ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(this.oldContainer, null, this.getEditorController());
                    result.add(fxControllerJob);
                }
                FXOMObject child = this.oldContainerChildren.iterator().next();
                SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(child, this.getEditorController());
                result.add(setDocumentRoot);
                if (isFxRoot) {
                    ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                    result.add(fxRootJob);
                }
                if (fxController != null) {
                    ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(child, fxController, this.getEditorController());
                    result.add(fxControllerJob);
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return "Unwrap";
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        return new ObjectSelectionGroup(this.oldContainerChildren, this.oldContainerChildren.iterator().next(), null);
    }

    protected List<Job> addChildrenJobs(FXOMPropertyC containerProperty, int start, List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int index = start;
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(child, containerProperty, index++, this.getEditorController());
            jobs.add(addValueJob);
        }
        return jobs;
    }

    protected List<Job> removeChildrenJobs(FXOMPropertyC containerProperty, List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(child, this.getEditorController());
            jobs.add(removeValueJob);
        }
        return jobs;
    }

    protected List<Job> modifyChildrenJobs(List<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (this.oldContainer.getSceneGraphObject() instanceof Node);
        Node oldContainerNode = (Node)this.oldContainer.getSceneGraphObject();
        for (FXOMObject child : children) {
            assert (child.getSceneGraphObject() instanceof Node);
            Node childNode = (Node)child.getSceneGraphObject();
            double currentLayoutX = childNode.getLayoutX();
            double currentLayoutY = childNode.getLayoutY();
            if (newContainerMask.isFreeChildPositioning()) {
                Point2D nextLayoutXY = oldContainerNode.localToParent(currentLayoutX, currentLayoutY);
                ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", nextLayoutXY.getX(), this.getEditorController());
                jobs.add(modifyLayoutX);
                ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", nextLayoutXY.getY(), this.getEditorController());
                jobs.add(modifyLayoutY);
            } else {
                ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", 0.0, this.getEditorController());
                jobs.add(modifyLayoutX);
                ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", 0.0, this.getEditorController());
                jobs.add(modifyLayoutY);
            }
            if (!(child instanceof FXOMInstance)) continue;
            FXOMInstance fxomInstance = (FXOMInstance)child;
            for (FXOMProperty p : fxomInstance.getProperties().values()) {
                Class<?> residentClass = p.getName().getResidenceClass();
                if (residentClass == null || residentClass == this.newContainer.getDeclaredClass()) continue;
                jobs.add(new RemovePropertyJob(p, this.getEditorController()));
            }
        }
        return jobs;
    }

    private List<FXOMObject> getChildren(FXOMInstance container) {
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        ArrayList<FXOMObject> result = new ArrayList<FXOMObject>();
        if (mask.isAcceptingSubComponent()) {
            if (TabPane.class.isAssignableFrom(container.getDeclaredClass())) {
                List<FXOMObject> tabs = mask.getSubComponents();
                if (tabs.size() >= 1) {
                    FXOMObject tab = tabs.get(0);
                    DesignHierarchyMask tabMask = new DesignHierarchyMask(tab);
                    assert (tabMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
                    if (tabMask.getAccessory(DesignHierarchyMask.Accessory.CONTENT) != null) {
                        result.add(tabMask.getAccessory(DesignHierarchyMask.Accessory.CONTENT));
                    }
                }
            } else {
                result.addAll(mask.getSubComponents());
            }
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CENTER) && mask.getAccessory(DesignHierarchyMask.Accessory.CENTER) != null) {
            result.add(mask.getAccessory(DesignHierarchyMask.Accessory.CENTER));
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.DP_CONTENT) && mask.getAccessory(DesignHierarchyMask.Accessory.DP_CONTENT) != null) {
            result.add(mask.getAccessory(DesignHierarchyMask.Accessory.DP_CONTENT));
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) && mask.getAccessory(DesignHierarchyMask.Accessory.CONTENT) != null) {
            result.add(mask.getAccessory(DesignHierarchyMask.Accessory.CONTENT));
        }
        return result;
    }
}

