/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.AbstractDecoration;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.handles.AbstractGenericHandles;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;

public abstract class AbstractResilientHandles<T>
extends AbstractGenericHandles<T> {
    private boolean ready;

    public AbstractResilientHandles(ContentPanelController contentPanelController, FXOMObject fxomObject, Class<T> sceneGraphClass) {
        super(contentPanelController, fxomObject, sceneGraphClass);
        this.getRootNode().setVisible(false);
    }

    public void setReady(boolean ready) {
        if (this.ready != ready) {
            this.ready = ready;
            this.readyDidChange();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    @Override
    public void reconcile() {
        assert (this.getState() == AbstractDecoration.State.NEEDS_RECONCILE);
        if (this.ready) {
            this.stopListeningToSceneGraphObject();
        }
        this.updateSceneGraphObject();
        if (this.ready) {
            this.startListeningToSceneGraphObject();
            this.layoutDecoration();
        }
    }

    @Override
    public Point2D sceneGraphObjectToDecoration(double x, double y, boolean snapToPixel) {
        assert (this.ready);
        return super.sceneGraphObjectToDecoration(x, y, snapToPixel);
    }

    @Override
    public Transform getSceneGraphObjectToDecorationTransform() {
        assert (this.ready);
        return super.getSceneGraphObjectToDecorationTransform();
    }

    @Override
    protected void rootNodeSceneDidChange() {
        if (this.ready) {
            if (this.getRootNode().getScene() == null) {
                this.getRootNode().setVisible(false);
                this.stopListeningToSceneGraphObject();
            } else {
                this.layoutDecoration();
                this.startListeningToSceneGraphObject();
                this.getRootNode().setVisible(true);
            }
        }
    }

    private void readyDidChange() {
        if (this.getRootNode().getScene() != null) {
            if (this.ready) {
                this.layoutDecoration();
                this.startListeningToSceneGraphObject();
                this.getRootNode().setVisible(true);
            } else {
                this.getRootNode().setVisible(false);
                this.stopListeningToSceneGraphObject();
            }
        }
    }
}

