/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabOutline;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.TabPaneDesignInfoX;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.pring.AbstractPring;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.AbstractGesture;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.SelectWithPringGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.paint.Paint;

public class TabPring
extends AbstractPring<Tab> {
    private final TabOutline tabOutline;
    private Node tabNode;

    public TabPring(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController, fxomInstance, Tab.class);
        assert (fxomInstance.getSceneGraphObject() instanceof Tab);
        this.tabOutline = new TabOutline((Tab)this.getSceneGraphObject());
        this.tabOutline.getRingPath().getStyleClass().add((Object)"parent-ring");
        this.getRootNode().getChildren().add((Object)this.tabOutline.getRingPath());
        this.attachPring((Node)this.tabOutline.getRingPath());
    }

    public FXOMInstance getFxomInstance() {
        return (FXOMInstance)this.getFxomObject();
    }

    @Override
    protected void layoutDecoration() {
        this.tabOutline.layout(this);
    }

    @Override
    public void changeStroke(Paint stroke) {
        this.tabOutline.getRingPath().setStroke(stroke);
    }

    @Override
    public Bounds getSceneGraphObjectBounds() {
        return ((Tab)this.getSceneGraphObject()).getTabPane().getLayoutBounds();
    }

    @Override
    public Node getSceneGraphObjectProxy() {
        return ((Tab)this.getSceneGraphObject()).getTabPane();
    }

    @Override
    protected void startListeningToSceneGraphObject() {
        assert (this.tabNode == null);
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.startListeningToLayoutBounds((Node)tabPane);
        this.startListeningToLocalToSceneTransform((Node)tabPane);
        TabPaneDesignInfoX di = new TabPaneDesignInfoX();
        this.tabNode = di.getTabNode(tabPane, (Tab)this.getSceneGraphObject());
        this.startListeningToBoundsInParent(this.tabNode);
    }

    @Override
    protected void stopListeningToSceneGraphObject() {
        assert (this.tabNode != null);
        TabPane tabPane = ((Tab)this.getSceneGraphObject()).getTabPane();
        this.stopListeningToLayoutBounds((Node)tabPane);
        this.stopListeningToLocalToSceneTransform((Node)tabPane);
        this.stopListeningToBoundsInParent(this.tabNode);
        this.tabNode = null;
    }

    @Override
    public AbstractGesture findGesture(Node node) {
        SelectWithPringGesture result = node == this.tabOutline.getRingPath() ? new SelectWithPringGesture(this.getContentPanelController(), this.getFxomInstance()) : null;
        return result;
    }

    private void attachPring(Node node) {
        TabPring.attachPring(node, this);
    }
}

