/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.AbstractResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.RegionResizer;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.web.WebView;

public class WebViewResizer
extends AbstractResizer<WebView> {
    private final double originalMinWidth;
    private final double originalMinHeight;
    private final double originalPrefWidth;
    private final double originalPrefHeight;
    private final double originalMaxWidth;
    private final double originalMaxHeight;
    private final PropertyName minWidthName = new PropertyName("minWidth");
    private final PropertyName minHeightName = new PropertyName("minHeight");
    private final PropertyName prefWidthName = new PropertyName("prefWidth");
    private final PropertyName prefHeightName = new PropertyName("prefHeight");
    private final PropertyName maxWidthName = new PropertyName("maxWidth");
    private final PropertyName maxHeightName = new PropertyName("maxHeight");
    private final List<PropertyName> propertyNames = new ArrayList<PropertyName>();

    public WebViewResizer(WebView sceneGraphObject) {
        super(sceneGraphObject);
        this.originalMinWidth = sceneGraphObject.getMinWidth();
        this.originalMinHeight = sceneGraphObject.getMinHeight();
        this.originalPrefWidth = sceneGraphObject.getPrefWidth();
        this.originalPrefHeight = sceneGraphObject.getPrefHeight();
        this.originalMaxWidth = sceneGraphObject.getMaxWidth();
        this.originalMaxHeight = sceneGraphObject.getMaxHeight();
        this.propertyNames.add(this.prefWidthName);
        this.propertyNames.add(this.prefHeightName);
        this.propertyNames.add(this.minWidthName);
        this.propertyNames.add(this.minHeightName);
        this.propertyNames.add(this.maxWidthName);
        this.propertyNames.add(this.maxHeightName);
    }

    @Override
    public final Bounds computeBounds(double width, double height) {
        return new BoundingBox(0.0, 0.0, (double)Math.round(width), (double)Math.round(height));
    }

    @Override
    public AbstractResizer.Feature getFeature() {
        return AbstractResizer.Feature.FREE;
    }

    @Override
    public void changeWidth(double width) {
        double w = Math.round(width);
        ((WebView)this.sceneGraphObject).setPrefWidth(w);
        if (this.originalMinWidth != -1.0 && this.originalMinWidth != Double.NEGATIVE_INFINITY) {
            ((WebView)this.sceneGraphObject).setMinWidth(Math.min(w, this.originalMinWidth));
        }
        if (this.originalMaxWidth != -1.0 && this.originalMaxWidth != Double.NEGATIVE_INFINITY) {
            ((WebView)this.sceneGraphObject).setMaxWidth(Math.max(w, this.originalMaxWidth));
        }
    }

    @Override
    public void changeHeight(double height) {
        double h = Math.round(height);
        ((WebView)this.sceneGraphObject).setPrefHeight(h);
        if (this.originalMinHeight != -1.0 && this.originalMinHeight != Double.NEGATIVE_INFINITY) {
            ((WebView)this.sceneGraphObject).setMinHeight(Math.min(h, this.originalMinHeight));
        }
        if (this.originalMaxHeight != -1.0 && this.originalMaxHeight != Double.NEGATIVE_INFINITY) {
            ((WebView)this.sceneGraphObject).setMaxHeight(Math.max(h, this.originalMaxHeight));
        }
    }

    @Override
    public void revertToOriginalSize() {
        ((WebView)this.sceneGraphObject).setMinWidth(this.originalMinWidth);
        ((WebView)this.sceneGraphObject).setMinHeight(this.originalMinHeight);
        ((WebView)this.sceneGraphObject).setPrefWidth(this.originalPrefWidth);
        ((WebView)this.sceneGraphObject).setPrefHeight(this.originalPrefHeight);
        ((WebView)this.sceneGraphObject).setMaxWidth(this.originalMaxWidth);
        ((WebView)this.sceneGraphObject).setMaxHeight(this.originalMaxHeight);
    }

    @Override
    public List<PropertyName> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Object getValue(PropertyName propertyName) {
        assert (propertyName != null);
        assert (this.propertyNames.contains(propertyName));
        String result = propertyName.equals(this.minWidthName) ? RegionResizer.makePrefSizeString(((WebView)this.sceneGraphObject).getMinWidth()) : (propertyName.equals(this.minHeightName) ? RegionResizer.makePrefSizeString(((WebView)this.sceneGraphObject).getMinHeight()) : (propertyName.equals(this.prefWidthName) ? RegionResizer.makeComputedSizeString(((WebView)this.sceneGraphObject).getPrefWidth()) : (propertyName.equals(this.prefHeightName) ? RegionResizer.makeComputedSizeString(((WebView)this.sceneGraphObject).getPrefHeight()) : (propertyName.equals(this.maxWidthName) ? RegionResizer.makePrefSizeString(((WebView)this.sceneGraphObject).getMaxWidth()) : (propertyName.equals(this.maxHeightName) ? RegionResizer.makePrefSizeString(((WebView)this.sceneGraphObject).getMaxHeight()) : null)))));
        return result;
    }

    @Override
    public Map<PropertyName, Object> getChangeMap() {
        HashMap<PropertyName, Object> result = new HashMap<PropertyName, Object>();
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getMinWidth(), this.originalMinWidth)) {
            result.put(this.minWidthName, ((WebView)this.sceneGraphObject).getMinWidth());
        }
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getMinHeight(), this.originalMinHeight)) {
            result.put(this.minHeightName, ((WebView)this.sceneGraphObject).getMinHeight());
        }
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getPrefWidth(), this.originalPrefWidth)) {
            result.put(this.prefWidthName, ((WebView)this.sceneGraphObject).getPrefWidth());
        }
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getPrefHeight(), this.originalPrefHeight)) {
            result.put(this.prefHeightName, ((WebView)this.sceneGraphObject).getPrefHeight());
        }
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getMaxWidth(), this.originalMaxWidth)) {
            result.put(this.maxWidthName, ((WebView)this.sceneGraphObject).getMaxWidth());
        }
        if (!MathUtils.equals(((WebView)this.sceneGraphObject).getMaxHeight(), this.originalMaxHeight)) {
            result.put(this.maxHeightName, ((WebView)this.sceneGraphObject).getMaxHeight());
        }
        return result;
    }
}

