/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.resizer.TableColumnResizer;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.gesture.mouse.AbstractMouseGesture;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyEvent;

public class ResizeTableColumnGesture
extends AbstractMouseGesture {
    private final FXOMInstance columnInstance;
    private TableColumnResizer resizer;

    public ResizeTableColumnGesture(ContentPanelController contentPanelController, FXOMInstance fxomInstance) {
        super(contentPanelController);
        assert (fxomInstance != null);
        assert (fxomInstance.getSceneGraphObject() instanceof TableColumn);
        this.columnInstance = fxomInstance;
    }

    @Override
    protected void mousePressed() {
    }

    @Override
    protected void mouseDragStarted() {
        assert (this.resizer == null);
        assert (this.columnInstance.getSceneGraphObject() instanceof TableColumn);
        this.resizer = new TableColumnResizer((TableColumn)this.columnInstance.getSceneGraphObject());
        this.mouseDragged();
    }

    @Override
    protected void mouseDragged() {
        assert (this.resizer != null);
        double startSceneX = this.getMousePressedEvent().getSceneX();
        double startSceneY = this.getMousePressedEvent().getSceneY();
        double currentSceneX = this.getLastMouseEvent().getSceneX();
        double currentSceneY = this.getLastMouseEvent().getSceneY();
        TableView tableView = this.resizer.getTableColumn().getTableView();
        Point2D start = tableView.sceneToLocal(startSceneX, startSceneY, true);
        Point2D current = tableView.sceneToLocal(currentSceneX, currentSceneY, true);
        double dx = current.getX() - start.getX();
        this.resizer.updateWidth(dx);
        tableView.layout();
    }

    @Override
    protected void mouseDragEnded() {
        assert (this.resizer != null);
        Map<PropertyName, Object> changeMap = this.resizer.getChangeMap();
        Map<PropertyName, Object> changeMapNext = this.resizer.getChangeMapNext();
        this.userDidCancel();
        EditorController editorController = this.contentPanelController.getEditorController();
        BatchJob batchJob = new BatchJob(editorController, true, I18N.getString("label.action.edit.resize.column"));
        if (!changeMap.isEmpty()) {
            batchJob.addSubJobs(this.makeResizeJob(this.columnInstance, changeMap));
        }
        if (!changeMapNext.isEmpty()) {
            batchJob.addSubJobs(this.makeResizeJob(this.columnInstance.getNextSlibing(), changeMapNext));
        }
        if (batchJob.isExecutable()) {
            editorController.getJobManager().push(batchJob);
        }
        this.resizer = null;
    }

    @Override
    protected void mouseReleased() {
    }

    @Override
    protected void keyEvent(KeyEvent e) {
    }

    @Override
    protected void userDidCancel() {
        this.resizer.revertToOriginalSize();
        this.resizer.getTableColumn().getTableView().layout();
    }

    private List<Job> makeResizeJob(FXOMObject columnObject, Map<PropertyName, Object> changeMap) {
        assert (columnObject.getSceneGraphObject() instanceof TableColumn);
        assert (columnObject instanceof FXOMInstance);
        ArrayList<Job> result = new ArrayList<Job>();
        Metadata metadata = Metadata.getMetadata();
        HashMap<ValuePropertyMetadata, Object> metaValueMap = new HashMap<ValuePropertyMetadata, Object>();
        for (Map.Entry<PropertyName, Object> entry : changeMap.entrySet()) {
            ValuePropertyMetadata vpm = metadata.queryValueProperty(this.columnInstance, entry.getKey());
            assert (vpm != null);
            metaValueMap.put(vpm, entry.getValue());
        }
        for (Map.Entry<PropertyName, Object> entry : metaValueMap.entrySet()) {
            ModifyObjectJob job = new ModifyObjectJob((FXOMInstance)columnObject, (ValuePropertyMetadata)((Object)entry.getKey()), entry.getValue(), this.contentPanelController.getEditorController());
            result.add(job);
        }
        return result;
    }
}

