/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;

public class StringEditor
extends PropertyEditor {
    private TextInputControl textField = new TextField();
    private EventHandler<ActionEvent> valueListener;

    public StringEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.initialize();
    }

    private void initialize() {
        this.valueListener = event -> {
            this.userUpdateValueProperty(this.getValue());
            this.textField.selectAll();
        };
        this.setTextEditorBehavior(this, (Control)this.textField, this.valueListener);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
    }

    @Override
    public Object getValue() {
        return EditorUtils.getPlainString(this.textField.getText());
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value == null) {
            this.textField.setText(null);
            return;
        }
        assert (value instanceof String);
        String val = (String)value;
        this.textField.setText(val);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.setLayoutFormat(PropertyEditor.LayoutFormat.DOUBLE_LINE);
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.textField);
    }

    @Override
    protected void valueIsIndeterminate() {
        StringEditor.handleIndeterminate((Node)this.textField);
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.textField.requestFocus());
    }
}

