/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.popupeditors.PopupEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextField;

public class StringPopupEditor
extends PopupEditor {
    @FXML
    TextField textField;
    private Parent root;

    public StringPopupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
    }

    @Override
    public void initializePopupContent() {
        this.root = EditorUtils.loadPopupFxml("StringPopupEditor.fxml", this);
        assert (this.textField != null);
        this.textField.setOnAction(t -> this.commitValue(this.textField.getText()));
    }

    @Override
    public void setPopupContentValue(Object value) {
        if (value == null) {
            this.textField.setText(null);
        } else {
            assert (value instanceof String);
            this.textField.setText((String)value);
        }
    }

    @Override
    public String getPreviewString(Object value) {
        if (value == null) {
            return "";
        }
        String valueAsString = this.isIndeterminate() ? "-" : value.toString();
        return valueAsString;
    }

    @Override
    public Node getPopupContentNode() {
        return this.root;
    }
}

