/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.report;

import com.oracle.javafx.scenebuilder.kit.editor.report.CSSParsingReport;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;

public class ErrorReportEntry {
    private final FXOMNode fxomNode;
    private final Type type;
    private final CSSParsingReport cssParsingReport;

    public ErrorReportEntry(FXOMNode fxomNode, Type type, CSSParsingReport cssParsingReport) {
        assert (fxomNode != null);
        assert (type == Type.INVALID_CSS_CONTENT == (cssParsingReport != null));
        this.fxomNode = fxomNode;
        this.type = type;
        this.cssParsingReport = cssParsingReport;
    }

    public ErrorReportEntry(FXOMNode fxomNode, Type type) {
        this(fxomNode, type, null);
    }

    public FXOMNode getFxomNode() {
        return this.fxomNode;
    }

    public Type getType() {
        return this.type;
    }

    public CSSParsingReport getCssParsingReport() {
        return this.cssParsingReport;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append("(fxomNode=");
        result.append(this.fxomNode.getClass().getSimpleName());
        result.append(",type=");
        result.append(this.type.toString());
        switch (this.type) {
            case UNRESOLVED_CLASS: {
                break;
            }
            case UNRESOLVED_LOCATION: {
                result.append(",location=");
                break;
            }
            case UNRESOLVED_RESOURCE: {
                result.append(",resource=");
                break;
            }
            case INVALID_CSS_CONTENT: {
                result.append(",css file=");
                break;
            }
            case UNSUPPORTED_EXPRESSION: {
                result.append(",expression=");
            }
        }
        if (this.fxomNode instanceof FXOMPropertyT) {
            FXOMPropertyT fxomProperty = (FXOMPropertyT)this.fxomNode;
            result.append(fxomProperty.getValue());
        } else if (this.fxomNode instanceof FXOMIntrinsic) {
            FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)this.fxomNode;
            result.append(fxomIntrinsic.getSource());
        } else {
            result.append("?");
        }
        result.append(")");
        return result.toString();
    }

    public static enum Type {
        UNRESOLVED_CLASS,
        UNRESOLVED_LOCATION,
        UNRESOLVED_RESOURCE,
        INVALID_CSS_CONTENT,
        UNSUPPORTED_EXPRESSION;

    }
}

