/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientStateBackup;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoubleArrayPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ListValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;

class FXOMRefresher {
    FXOMRefresher() {
    }

    public void refresh(FXOMDocument document) {
        String fxmlText = null;
        try {
            fxmlText = document.getFxmlText();
            FXOMDocument newDocument = new FXOMDocument(fxmlText, document.getLocation(), document.getClassLoader(), document.getResources(), false);
            TransientStateBackup backup = new TransientStateBackup(document);
            this.refreshDocument(document, newDocument);
            backup.restore();
            this.synchronizeDividerPositions(document);
        }
        catch (IOException | RuntimeException x) {
            StringBuilder sb = new StringBuilder();
            sb.append("Bug in ");
            sb.append(this.getClass().getSimpleName());
            if (fxmlText != null) {
                try {
                    File fxmlFile = File.createTempFile("DTL-5996-", ".fxml");
                    try (PrintWriter pw = new PrintWriter(fxmlFile, "UTF-8");){
                        pw.write(fxmlText);
                        sb.append(": FXML dumped in ");
                        sb.append(fxmlFile.getPath());
                    }
                }
                catch (IOException xx) {
                    sb.append(": no FXML dumped");
                }
            } else {
                sb.append(": no FXML dumped");
            }
            throw new IllegalStateException(sb.toString(), x);
        }
    }

    private void refreshDocument(FXOMDocument currentDocument, FXOMDocument newDocument) {
        currentDocument.setSceneGraphRoot(newDocument.getSceneGraphRoot());
        if (currentDocument.getSceneGraphRoot() instanceof Parent) {
            Parent rootParent = (Parent)currentDocument.getSceneGraphRoot();
            rootParent.getStyleClass().add(0, (Object)"root");
        }
        if (currentDocument.getFxomRoot() != null) {
            this.refreshFxomObject(currentDocument.getFxomRoot(), newDocument.getFxomRoot());
        }
    }

    private void refreshFxomObject(FXOMObject currentObject, FXOMObject newObject) {
        assert (currentObject != null);
        assert (newObject != null);
        assert (currentObject.getClass() == newObject.getClass());
        currentObject.setSceneGraphObject(newObject.getSceneGraphObject());
        if (currentObject instanceof FXOMInstance) {
            this.refreshFxomInstance((FXOMInstance)currentObject, (FXOMInstance)newObject);
        } else if (currentObject instanceof FXOMCollection) {
            this.refreshFxomCollection((FXOMCollection)currentObject, (FXOMCollection)newObject);
        } else if (currentObject instanceof FXOMIntrinsic) {
            this.refreshFxomIntrinsic((FXOMIntrinsic)currentObject, (FXOMIntrinsic)newObject);
        } else assert (false) : "Unexpected fxom object " + currentObject;
    }

    private void refreshFxomInstance(FXOMInstance currentInstance, FXOMInstance newInstance) {
        assert (currentInstance != null);
        assert (newInstance != null);
        assert (currentInstance.getClass() == newInstance.getClass());
        currentInstance.setDeclaredClass(newInstance.getDeclaredClass());
        Set<PropertyName> currentNames = currentInstance.getProperties().keySet();
        Set<PropertyName> newNames = newInstance.getProperties().keySet();
        assert (currentNames.equals(newNames));
        for (PropertyName name : currentNames) {
            FXOMProperty currentProperty = currentInstance.getProperties().get(name);
            FXOMProperty newProperty = newInstance.getProperties().get(name);
            this.refreshFxomProperty(currentProperty, newProperty);
        }
    }

    private void refreshFxomCollection(FXOMCollection currentCollection, FXOMCollection newCollection) {
        assert (currentCollection != null);
        assert (newCollection != null);
        currentCollection.setDeclaredClass(newCollection.getDeclaredClass());
        this.refreshFxomObjects(currentCollection.getItems(), newCollection.getItems());
    }

    private void refreshFxomIntrinsic(FXOMIntrinsic currentIntrinsic, FXOMIntrinsic newIntrinsic) {
        assert (currentIntrinsic != null);
        assert (newIntrinsic != null);
        currentIntrinsic.setSourceSceneGraphObject(newIntrinsic.getSourceSceneGraphObject());
    }

    private void refreshFxomProperty(FXOMProperty currentProperty, FXOMProperty newProperty) {
        assert (currentProperty != null);
        assert (newProperty != null);
        assert (currentProperty.getName().equals(newProperty.getName()));
        if (currentProperty instanceof FXOMPropertyT) {
            assert (newProperty instanceof FXOMPropertyT);
            FXOMPropertyT currentPT = (FXOMPropertyT)currentProperty;
            FXOMPropertyT newPT = (FXOMPropertyT)newProperty;
            assert (currentPT.getValue().equals(newPT.getValue()));
        } else {
            assert (currentProperty instanceof FXOMPropertyC);
            assert (newProperty instanceof FXOMPropertyC);
            FXOMPropertyC currentPC = (FXOMPropertyC)currentProperty;
            FXOMPropertyC newPC = (FXOMPropertyC)newProperty;
            this.refreshFxomObjects(currentPC.getValues(), newPC.getValues());
        }
    }

    private void refreshFxomObjects(List<FXOMObject> currentObjects, List<FXOMObject> newObjects) {
        assert (currentObjects != null);
        assert (newObjects != null);
        assert (currentObjects.size() == newObjects.size());
        int count = currentObjects.size();
        for (int i = 0; i < count; ++i) {
            FXOMObject currentObject = currentObjects.get(i);
            FXOMObject newObject = newObjects.get(i);
            this.refreshFxomObject(currentObject, newObject);
        }
    }

    private void synchronizeDividerPositions(FXOMDocument document) {
        FXOMObject fxomRoot = document.getFxomRoot();
        if (fxomRoot != null) {
            Metadata metadata = Metadata.getMetadata();
            PropertyName dividerPositionsName = new PropertyName("dividerPositions");
            List<FXOMObject> candidates = fxomRoot.collectObjectWithSceneGraphObjectClass(SplitPane.class);
            for (FXOMObject fxomObject : candidates) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
                assert (fxomInstance.getSceneGraphObject() instanceof SplitPane);
                SplitPane splitPane = (SplitPane)fxomInstance.getSceneGraphObject();
                splitPane.layout();
                ValuePropertyMetadata vpm = metadata.queryValueProperty(fxomInstance, dividerPositionsName);
                assert (vpm instanceof ListValuePropertyMetadata) : "vpm.getClass()=" + vpm.getClass().getSimpleName();
                DoubleArrayPropertyMetadata davpm = (DoubleArrayPropertyMetadata)vpm;
                davpm.synchronizeWithSceneGraphObject(fxomInstance);
            }
        }
    }
}

