/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientNode;
import com.oracle.javafx.scenebuilder.kit.fxom.TransientProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.glue.GlueElement;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.DefaultProperty;

class TransientObject
extends TransientNode {
    private final Class<?> declaredClass;
    private final String unknownClassName;
    private final GlueElement glueElement;
    private final List<FXOMProperty> properties = new ArrayList<FXOMProperty>();
    private final List<FXOMObject> collectedItems = new ArrayList<FXOMObject>();
    private String fxRootType;

    public TransientObject(TransientNode parentNode, Class<?> declaredClass, GlueElement glueElement) {
        super(parentNode);
        assert (declaredClass != null);
        assert (glueElement != null);
        assert (glueElement.getTagName().equals(PropertyName.makeClassFullName(declaredClass)) || glueElement.getTagName().equals(declaredClass.getCanonicalName()));
        this.declaredClass = declaredClass;
        this.unknownClassName = null;
        this.glueElement = glueElement;
    }

    public TransientObject(TransientNode parentNode, String unknownClassName, GlueElement glueElement) {
        super(parentNode);
        assert (unknownClassName != null);
        assert (glueElement != null);
        assert (glueElement.getTagName().equals(unknownClassName));
        this.declaredClass = null;
        this.unknownClassName = unknownClassName;
        this.glueElement = glueElement;
    }

    public TransientObject(TransientNode parentNode, GlueElement glueElement) {
        super(parentNode);
        assert (glueElement != null);
        assert (glueElement.getTagName().equals("fx:root"));
        this.declaredClass = null;
        this.unknownClassName = null;
        this.glueElement = glueElement;
    }

    public List<FXOMProperty> getProperties() {
        return this.properties;
    }

    public List<FXOMObject> getCollectedItems() {
        return this.collectedItems;
    }

    public void setFxRootType(String fxRootType) {
        this.fxRootType = fxRootType;
    }

    public FXOMObject makeFxomObject(FXOMDocument fxomDocument) {
        FXOMObject result;
        if (this.declaredClass != null) {
            assert (this.getSceneGraphObject() != null);
            if (this.getSceneGraphObject() instanceof List) {
                assert (this.properties.isEmpty());
                result = new FXOMCollection(fxomDocument, this.glueElement, this.declaredClass, this.getSceneGraphObject(), this.collectedItems);
            } else {
                assert (this.fxRootType == null);
                this.addDefaultProperty(fxomDocument, this.declaredClass);
                result = new FXOMInstance(fxomDocument, this.glueElement, this.declaredClass, this.getSceneGraphObject(), this.properties);
            }
        } else if (this.unknownClassName != null) {
            assert (this.glueElement.getTagName().equals(this.unknownClassName));
            assert (this.fxRootType == null);
            result = new FXOMInstance(fxomDocument, this.glueElement, this.properties);
        } else {
            assert (this.glueElement.getTagName().equals("fx:root"));
            assert (this.fxRootType != null);
            Class<?> rootClass = this.getSceneGraphObject().getClass();
            assert (this.fxRootType.equals(rootClass.getName()) || this.fxRootType.equals(rootClass.getSimpleName()));
            this.addDefaultProperty(fxomDocument, rootClass);
            result = new FXOMInstance(fxomDocument, this.glueElement, rootClass, this.getSceneGraphObject(), this.properties);
        }
        return result;
    }

    private void addDefaultProperty(FXOMDocument fxomDocument, Class<?> klass) {
        DefaultProperty annotation = klass.getAnnotation(DefaultProperty.class);
        if (annotation != null && this.collectedItems.size() >= 1) {
            assert (annotation.value() != null);
            PropertyName defaultPropertyName = new PropertyName(annotation.value());
            this.createDefaultProperty(defaultPropertyName, fxomDocument);
        }
    }

    private void createDefaultProperty(PropertyName defaultName, FXOMDocument fxomDocument) {
        GlueElement propertyElement = new GlueElement(this.glueElement.getDocument(), defaultName.toString(), this.glueElement);
        propertyElement.setSynthetic(true);
        propertyElement.addBefore(this.collectedItems.get(0).getGlueElement());
        for (FXOMObject item : this.collectedItems) {
            item.getGlueElement().addToParent(propertyElement);
        }
        TransientProperty transientProperty = new TransientProperty(this, defaultName, propertyElement);
        transientProperty.getValues().addAll(this.collectedItems);
        this.properties.add(transientProperty.makeFxomProperty(fxomDocument));
    }
}

