/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.fxom.sampledata;

import com.oracle.javafx.scenebuilder.kit.fxom.sampledata.AbstractSampleData;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;

class SpinnerSampleData
extends AbstractSampleData {
    private final List<String> samples = new ArrayList<String>();
    private SpinnerValueFactory<String> valueFactory;
    private int index = 0;
    private static final int ALPHABET_SIZE = 26;

    public SpinnerSampleData() {
        for (int i = 0; i < 26; ++i) {
            this.samples.add(SpinnerSampleData.alphabet(i));
        }
    }

    @Override
    public void applyTo(Object sceneGraphObject) {
        assert (sceneGraphObject != null);
        Spinner spinner = (Spinner)sceneGraphObject;
        this.valueFactory = spinner.getValueFactory();
        spinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory<String>(){

            public void decrement(int steps) {
                SpinnerSampleData.this.index = Math.max(SpinnerSampleData.this.index - 1, 0);
                this.setValue(SpinnerSampleData.this.samples.get(SpinnerSampleData.this.index));
            }

            public void increment(int steps) {
                SpinnerSampleData.this.index = Math.min(SpinnerSampleData.this.index + 1, 25);
                this.setValue(SpinnerSampleData.this.samples.get(SpinnerSampleData.this.index));
            }
        });
        assert (this.index == 0);
        spinner.getValueFactory().setValue((Object)this.samples.get(this.index));
    }

    @Override
    public void removeFrom(Object sceneGraphObject) {
        assert (sceneGraphObject != null);
        Spinner spinner = (Spinner)sceneGraphObject;
        spinner.setValueFactory(this.valueFactory);
    }
}

