/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.glossary;

class JavaTokenizer {
    private static final String unicodeHash = "\\u" + String.format("%04x", 35);

    private JavaTokenizer() {
        assert (false);
    }

    public static String tokenize(String text) throws ParseException {
        if (text.contains(unicodeHash)) {
            throw new ParseException("Source file contains the sequence '" + unicodeHash + "'");
        }
        String noHashText = text.replace("#", unicodeHash);
        int len = noHashText.length();
        StringBuilder tokens = new StringBuilder();
        int i = 0;
        while (i < len) {
            int nexti;
            char c = noHashText.charAt(i);
            switch (c) {
                case '/': {
                    nexti = JavaTokenizer.scanSlash(noHashText, i);
                    break;
                }
                case '\"': 
                case '\'': {
                    try {
                        nexti = JavaTokenizer.scanQuote(noHashText, i, c);
                        break;
                    }
                    catch (Error e) {
                        System.err.println(tokens.toString());
                        throw e;
                    }
                }
                case '\\': {
                    throw new ParseException("Backslash outside quotes");
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        nexti = JavaTokenizer.scanSpace(noHashText, i);
                        break;
                    }
                    if (c == '.') {
                        if (i + 1 >= len) {
                            throw new ParseException("Dot at end of file");
                        }
                        if (Character.isDigit(noHashText.charAt(i + 1))) {
                            nexti = JavaTokenizer.scanNumber(noHashText, i + 1);
                            break;
                        }
                        nexti = i + 1;
                        break;
                    }
                    nexti = c == '.' || Character.isDigit(c) ? JavaTokenizer.scanNumber(noHashText, i) : (Character.isJavaIdentifierStart(c) ? JavaTokenizer.scanIdentifier(noHashText, i) : i + 1);
                }
            }
            tokens.append('#').append(noHashText.substring(i, nexti));
            i = nexti;
        }
        return tokens.toString();
    }

    private static int scanSpace(String s, int i) {
        int len = s.length();
        while (i < len && Character.isWhitespace(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static int scanNumber(String s, int i) {
        int len = s.length();
        while (i < len) {
            char c = s.charAt(i);
            if (c == 'e' || c == 'E') {
                ++i;
            }
            if (c != '.' && !Character.isDigit(c) && !Character.isLetter(c)) break;
            ++i;
        }
        return i;
    }

    private static int scanIdentifier(String s, int i) {
        int len = s.length();
        while (i < len && Character.isJavaIdentifierPart(s.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static int scanSlash(String s, int i) throws ParseException {
        int len = s.length();
        if (i + 1 >= len) {
            return i + 1;
        }
        switch (s.charAt(i + 1)) {
            case '/': {
                int newline = s.indexOf(10, i);
                if (newline < 0) {
                    throw new ParseException("Unterminated // comment");
                }
                return newline + 1;
            }
            case '*': {
                int starSlash = s.indexOf("*/", i + 2);
                if (starSlash < 0) {
                    throw new ParseException("Unterminated /* comment");
                }
                return starSlash + 2;
            }
        }
        return i + 1;
    }

    private static int scanQuote(String s, int i, char quote) throws ParseException {
        assert (s.charAt(i) == quote);
        int len = s.length();
        while (++i < len && s.charAt(i) != quote) {
            if (s.charAt(i) != '\\') continue;
            ++i;
        }
        if (i >= len) {
            System.err.println(s);
            throw new ParseException("Unterminated char or string constant");
        }
        return i + 1;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String msg) {
            super(msg);
        }
    }
}

