/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.property.value;

import com.oracle.javafx.scenebuilder.kit.metadata.property.value.TextEncodablePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;

public class DoublePropertyMetadata
extends TextEncodablePropertyMetadata<Double> {
    private final DoubleKind kind;

    public DoublePropertyMetadata(PropertyName name, DoubleKind kind, boolean readWrite, Double defaultValue, InspectorPath inspectorPath) {
        super(name, Double.class, readWrite, defaultValue, inspectorPath);
        assert (kind != DoubleKind.NULLABLE_COORDINATE || defaultValue == null);
        this.kind = kind;
    }

    public DoubleKind getKind() {
        return this.kind;
    }

    public boolean isValidValue(Double value) {
        boolean result;
        if (this.kind == DoubleKind.NULLABLE_COORDINATE) {
            result = true;
        } else if (value == null) {
            result = false;
        } else {
            switch (this.kind) {
                case COORDINATE: {
                    result = true;
                    break;
                }
                case SIZE: {
                    result = 0.0 <= value;
                    break;
                }
                case USE_COMPUTED_SIZE: {
                    result = 0.0 <= value || value == -1.0;
                    break;
                }
                case USE_PREF_SIZE: {
                    result = 0.0 <= value || value == -1.0 || value == Double.NEGATIVE_INFINITY;
                    break;
                }
                case PERCENTAGE: {
                    result = value == -1.0 || 0.0 <= value && value <= 100.0;
                    break;
                }
                case EFFECT_SIZE: 
                case ANGLE: 
                case OPACITY: 
                case PROGRESS: {
                    result = true;
                    break;
                }
                default: {
                    assert (false);
                    result = false;
                }
            }
        }
        return result;
    }

    public Double getCanonicalValue(Double value) {
        Double result;
        if (value == null) {
            result = null;
        } else {
            switch (this.kind) {
                case COORDINATE: 
                case SIZE: 
                case USE_COMPUTED_SIZE: 
                case USE_PREF_SIZE: 
                case NULLABLE_COORDINATE: {
                    result = value;
                    break;
                }
                case EFFECT_SIZE: {
                    result = Math.min(255.0, Math.max(0.0, value));
                    break;
                }
                case ANGLE: {
                    result = Math.IEEEremainder(value, 360.0);
                    break;
                }
                case OPACITY: 
                case PROGRESS: {
                    result = Math.min(1.0, Math.max(0.0, value));
                    break;
                }
                default: {
                    assert (false);
                    result = value;
                }
            }
        }
        return result;
    }

    @Override
    public Double makeValueFromString(String string) {
        return Double.valueOf(string);
    }

    public static enum DoubleKind {
        COORDINATE,
        NULLABLE_COORDINATE,
        SIZE,
        USE_COMPUTED_SIZE,
        USE_PREF_SIZE,
        EFFECT_SIZE,
        ANGLE,
        OPACITY,
        PROGRESS,
        PERCENTAGE;

    }
}

