/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import com.sun.glass.ui.Application;
import com.sun.javafx.css.Style;
import com.sun.javafx.fxml.LoadListener;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.scene.control.skin.MenuBarSkin;
import com.sun.javafx.scene.input.PickResultChooser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.layout.GridPane;

public class Deprecation {
    public static final String CASPIAN_STYLESHEET = "com/sun/javafx/scene/control/skin/caspian/caspian.bss";
    public static final String CASPIAN_HIGHCONTRAST_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-highContrast.css";
    public static final String CASPIAN_EMBEDDED_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded.css";
    public static final String CASPIAN_EMBEDDED_HIGHCONTRAST_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-highContrast.css";
    public static final String CASPIAN_EMBEDDED_QVGA_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-qvga.css";
    public static final String CASPIAN_EMBEDDED_QVGA_HIGHCONTRAST_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/caspian/caspian-embedded-qvga-highContrast.css";
    public static final String MODENA_STYLESHEET = "com/sun/javafx/scene/control/skin/modena/modena.bss";
    public static final String MODENA_TOUCH_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch.css";
    public static final String MODENA_HIGHCONTRAST_BLACKONWHITE_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-blackOnWhite.css";
    public static final String MODENA_HIGHCONTRAST_WHITEONBLACK_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-whiteOnBlack.css";
    public static final String MODENA_HIGHCONTRAST_YELLOWONBLACK_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-highContrast-yellowOnBlack.css";
    public static final String MODENA_TOUCH_HIGHCONTRAST_BLACKONWHITE_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-blackOnWhite.css";
    public static final String MODENA_TOUCH_HIGHCONTRAST_WHITEONBLACK_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-whiteOnBlack.css";
    public static final String MODENA_TOUCH_HIGHCONTRAST_YELLOWONBLACK_STYLESHEET = "com/oracle/javafx/scenebuilder/kit/util/css/modena/modena-touch-highContrast-yellowOnBlack.css";

    private Deprecation() {
        assert (false);
    }

    public static Group createGroupWithNullParentStylesheets() {
        return new Group(){

            public List<String> impl_getAllParentStylesheets() {
                return null;
            }
        };
    }

    public static void setStyleMap(Node node, ObservableMap<StyleableProperty<?>, List<Style>> map) {
        node.impl_setStyleMap(map);
    }

    public static Map<StyleableProperty<?>, List<Style>> getStyleMap(Node node) {
        return node.impl_findStyles(null);
    }

    public static void reapplyCSS(Parent parent, String stylesheetPath) {
        assert (parent != null);
        String stylesheetPathWithForwardSlashes = stylesheetPath.replace("\\", "/");
        ObservableList stylesheets = parent.getStylesheets();
        for (String s : new LinkedList(stylesheets)) {
            if (!s.endsWith(stylesheetPathWithForwardSlashes)) continue;
            int index = stylesheets.indexOf(s);
            assert (index != -1);
            stylesheets.remove(index);
            stylesheets.add(index, s);
            break;
        }
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (child instanceof Parent) {
                Parent childParent = (Parent)child;
                Deprecation.reapplyCSS(childParent, stylesheetPath);
                continue;
            }
            if (!(child instanceof SubScene)) continue;
            SubScene childSubScene = (SubScene)child;
            Deprecation.reapplyCSS(childSubScene.getRoot(), stylesheetPath);
        }
    }

    public static Node getNode(Styleable styleable) {
        try {
            if (styleable instanceof MenuItem) {
                return ((MenuItem)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof PopupControl) {
                return ((PopupControl)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof TableColumn) {
                return ((TableColumn)styleable).impl_styleableGetNode();
            }
            if (styleable instanceof TreeTableColumn) {
                return ((TreeTableColumn)styleable).impl_styleableGetNode();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    public static List<Style> getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return Node.impl_getMatchingStyles((CssMetaData)cssMetaData, (Styleable)styleable);
    }

    public static String getUrl(Image image) {
        return image.impl_getUrl();
    }

    public static void setStaticLoad(FXMLLoader loader, boolean staticLoad) {
        loader.impl_setStaticLoad(staticLoad);
    }

    public static void setLoadListener(FXMLLoader loader, LoadListener loadListener) {
        loader.impl_setLoadListener(loadListener);
    }

    public static Node pick(Node node, double sceneX, double sceneY) {
        Point2D p = node.sceneToLocal(sceneX, sceneY, true);
        PickRay pickRay = new PickRay(p.getX(), p.getY(), 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        PickResultChooser prc = new PickResultChooser();
        node.impl_pickNode(pickRay, prc);
        return prc.getIntersectedNode();
    }

    public static void setDefaultSystemMenuBar(MenuBar menuBar) {
        MenuBarSkin.setDefaultSystemMenuBar((MenuBar)menuBar);
    }

    public static void setPlatformEventHandler(Application.EventHandler eventHandler) {
        Application.GetApplication().setEventHandler(eventHandler);
    }

    public static Application.EventHandler getPlatformEventHandler() {
        return Application.GetApplication().getEventHandler();
    }

    public static int getGridPaneColumnCount(GridPane gridPane) {
        return gridPane.impl_getColumnCount();
    }

    public static int getGridPaneRowCount(GridPane gridPane) {
        return gridPane.impl_getRowCount();
    }

    public static Bounds getGridPaneCellBounds(GridPane gridPane, int c, int r) {
        return gridPane.impl_getCellBounds(c, r);
    }

    public static void setTableColumnReordable(TableColumn tableColumn, boolean reordable) {
        tableColumn.impl_setReorderable(reordable);
    }

    public static URL getThemeTextStylesheet(String binaryCssUrlStr) {
        String textCssUrlStr = binaryCssUrlStr.replaceAll(".bss", ".css");
        try {
            return new URL(textCssUrlStr);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static JavaFXBuilderFactory newJavaFXBuilderFactory(ClassLoader classLoader) {
        return new JavaFXBuilderFactory(classLoader, false);
    }

    public static int getNodeLevel(TreeItem<?> item) {
        return TreeView.getNodeLevel(item);
    }

    public static Point2D localToLocal(Node source, double sourceX, double sourceY, Node target) {
        Point2D sceneXY = source.localToScene(sourceX, sourceY, true);
        return target.sceneToLocal(sceneXY, true);
    }

    public static Bounds localToLocal(Node source, Bounds sourceBounds, Node target) {
        Bounds sceneBounds = source.localToScene(sourceBounds, true);
        return target.sceneToLocal(sceneBounds, true);
    }
}

