/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker;

import java.util.Locale;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;

public class DoubleTextField
extends TextField {
    public void replaceText(int start, int end, String text) {
        String newText = this.getNewText(start, end, text);
        if (!(text.isEmpty() || newText.equals("-") || newText.equals(".") || newText.equals("-."))) {
            try {
                if (newText.toLowerCase(Locale.ROOT).contains("d") || newText.toLowerCase(Locale.ROOT).contains("f")) {
                    return;
                }
                newText = newText.replace(',', '.');
                Double.parseDouble(newText);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        text = text.replace(',', '.');
        super.replaceText(start, end, text);
    }

    public void paste() {
        String strToPaste = Clipboard.getSystemClipboard().getString();
        try {
            Double.parseDouble(strToPaste);
        }
        catch (NumberFormatException e) {
            return;
        }
        super.paste();
    }

    private String getNewText(int start, int end, String text) {
        String newText;
        String oldText = this.getText();
        String toReplace = oldText.substring(start, end);
        if (toReplace.isEmpty()) {
            newText = oldText + text;
        } else {
            String headerStr = oldText.substring(0, start);
            String trailerStr = "";
            if (end < oldText.length()) {
                trailerStr = oldText.substring(end, oldText.length());
            }
            newText = headerStr + text + trailerStr;
        }
        return newText;
    }
}

