/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPickerController;
import java.io.IOException;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;

public class PaintPicker
extends Pane {
    private final PaintPickerController controller;

    public PaintPicker(Delegate delegate) {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(PaintPicker.class.getResource("PaintPicker.fxml"));
        try {
            Object rootObject = loader.load();
            assert (rootObject instanceof Node);
            Node rootNode = (Node)rootObject;
            this.getChildren().add((Object)rootNode);
            Object ctl = loader.getController();
            assert (ctl instanceof PaintPickerController);
            this.controller = (PaintPickerController)ctl;
            this.controller.setDelegate(delegate);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public PaintPicker(Delegate delegate, Mode mode) {
        this(delegate);
        this.controller.setSingleMode(mode);
    }

    public final ObjectProperty<Paint> paintProperty() {
        return this.controller.paintProperty();
    }

    public final void setPaintProperty(Paint value) {
        this.controller.setPaintProperty(value);
        this.controller.updateUI(value);
    }

    public final Paint getPaintProperty() {
        return this.controller.getPaintProperty();
    }

    public final ReadOnlyBooleanProperty liveUpdateProperty() {
        return this.controller.liveUpdateProperty();
    }

    public boolean isLiveUpdate() {
        return this.controller.isLiveUpdate();
    }

    public static interface Delegate {
        public void handleError(String var1, Object ... var2);
    }

    public static enum Mode {
        COLOR,
        LINEAR,
        RADIAL;

    }
}

