/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.codeInsight;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonNames;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxGetterSetterPrototypeProvider
extends GetterSetterPrototypeProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxGetterSetterPrototypeProvider.class.getName()));

    public boolean canGeneratePrototypeFor(PsiField field) {
        return InheritanceUtil.isInheritor((PsiType)field.getType(), (String)"javafx.beans.value.ObservableValue");
    }

    public PsiMethod[] generateGetters(PsiField field) {
        Project project = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiMethod getter = GenerateMembersUtil.generateSimpleGetterPrototype((PsiField)field);
        PsiType wrappedType = JavaFxPsiUtil.getWrappedPropertyType(field, project, JavaFxCommonNames.ourReadOnlyMap);
        getter.setName(PropertyUtil.suggestGetterName((String)PropertyUtil.suggestPropertyName((PsiField)field), (PsiType)wrappedType));
        PsiTypeElement returnTypeElement = getter.getReturnTypeElement();
        LOG.assertTrue(returnTypeElement != null);
        returnTypeElement.replace((PsiElement)factory.createTypeElement(wrappedType));
        PsiCodeBlock getterBody = getter.getBody();
        LOG.assertTrue(getterBody != null);
        String fieldName = field.getName();
        getterBody.getStatements()[0].replace((PsiElement)factory.createStatementFromText("return " + fieldName + ".get();", (PsiElement)field));
        PsiMethod propertyGetter = PropertyUtil.generateGetterPrototype((PsiField)field);
        if (propertyGetter != null && fieldName != null) {
            propertyGetter.setName(JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(fieldName, VariableKind.FIELD) + "Property");
        }
        return new PsiMethod[]{getter, GenerateMembersUtil.annotateOnOverrideImplement((PsiClass)field.getContainingClass(), (PsiMethod)propertyGetter)};
    }

    public PsiMethod[] generateSetters(PsiField field) {
        PsiMethod setter = GenerateMembersUtil.generateSimpleSetterPrototype((PsiField)field);
        Project project = field.getProject();
        PsiType wrappedType = JavaFxPsiUtil.getWrappedPropertyType(field, project, JavaFxCommonNames.ourWritableMap);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeElement newTypeElement = elementFactory.createTypeElement(wrappedType);
        PsiParameter[] parameters = setter.getParameterList().getParameters();
        LOG.assertTrue(parameters.length == 1);
        PsiParameter parameter = parameters[0];
        PsiTypeElement typeElement = parameter.getTypeElement();
        LOG.assertTrue(typeElement != null);
        typeElement.replace((PsiElement)newTypeElement);
        PsiCodeBlock body = setter.getBody();
        LOG.assertTrue(body != null);
        body.getStatements()[0].replace((PsiElement)elementFactory.createStatementFromText("this." + field.getName() + ".set(" + parameter.getName() + ");", (PsiElement)field));
        return new PsiMethod[]{setter};
    }

    public PsiMethod[] findGetters(PsiClass psiClass, String propertyName) {
        String getterName = this.suggestGetterName(propertyName);
        PsiMethod specificGetter = psiClass.findMethodBySignature(JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createMethod(getterName, (PsiType)PsiType.VOID), false);
        if (specificGetter != null) {
            PsiMethod[] psiMethodArray;
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)false);
            if (getter == null) {
                PsiMethod[] psiMethodArray2 = new PsiMethod[1];
                psiMethodArray = psiMethodArray2;
                psiMethodArray2[0] = specificGetter;
            } else {
                PsiMethod[] psiMethodArray3 = new PsiMethod[2];
                psiMethodArray3[0] = getter;
                psiMethodArray = psiMethodArray3;
                psiMethodArray3[1] = specificGetter;
            }
            return psiMethodArray;
        }
        return super.findGetters(psiClass, propertyName);
    }

    public String suggestGetterName(String propertyName) {
        return propertyName + "Property";
    }

    public boolean isSimpleGetter(PsiMethod method, String oldPropertyName) {
        return method.getName().equals(this.suggestGetterName(oldPropertyName));
    }

    public boolean isReadOnly(PsiField field) {
        return !InheritanceUtil.isInheritor((PsiType)field.getType(), (String)"javafx.beans.value.WritableValue");
    }
}

