/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections.UnwrapTagFix;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxDefaultTagInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                PsiClass parentTagClass;
                super.visitXmlTag(tag);
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof JavaFxPropertyTagDescriptor && (parentTagClass = JavaFxPsiUtil.getTagClass(tag.getParentTag())) != null) {
                    String propertyName = JavaFxPsiUtil.getDefaultPropertyName(parentTagClass);
                    String tagName = tag.getName();
                    if (Comparing.strEqual((String)tagName, (String)propertyName) && !JavaFxDefaultTagInspection.isCollectionAssignment(parentTagClass, propertyName, tag)) {
                        TextRange startTagRange = XmlTagUtil.getStartTagRange((XmlTag)tag);
                        TextRange rangeInElement = startTagRange != null ? startTagRange.shiftRight(-tag.getTextOffset()) : null;
                        holder.registerProblem((PsiElement)tag, rangeInElement, "Default property tag could be removed", new LocalQuickFix[]{new UnwrapTagFix(tagName)});
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static boolean isCollectionAssignment(@NotNull PsiClass parentTagClass, @NotNull String propertyName, @NotNull XmlTag tag) {
        PsiType propertyType;
        PsiClass propertyClass;
        PsiMember property;
        PsiClass tagValueClass;
        if (parentTagClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentTagClass", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "isCollectionAssignment"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "isCollectionAssignment"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxDefaultTagInspection", "isCollectionAssignment"));
        }
        XmlTag[] subTags = tag.getSubTags();
        return subTags.length != 0 && JavaFxPsiUtil.isObservableCollection(tagValueClass = JavaFxPsiUtil.getTagValueClass(subTags[subTags.length - 1])) && (property = JavaFxPsiUtil.collectWritableProperties(parentTagClass).get(propertyName)) != null && JavaFxPsiUtil.isObservableCollection(propertyClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(propertyType = JavaFxPsiUtil.getWritablePropertyType(parentTagClass, (PsiElement)property))));
    }
}

