/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.rename.RenameXmlAttributeProcessor;
import com.intellij.util.NullableConsumer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxRenameAttributeProcessor
extends RenameXmlAttributeProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/refactoring/JavaFxRenameAttributeProcessor", "canProcessElement"));
        }
        if (element instanceof XmlAttributeValue && JavaFxFileTypeFactory.isFxml(element.getContainingFile())) {
            PsiElement parent = element.getParent();
            return parent instanceof XmlAttribute && "fx:id".equals(((XmlAttribute)parent).getName());
        }
        return false;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames, SearchScope scope) {
        JavaFxRenameAttributeProcessor.visitReferencedElements(element.getReferences(), (NullableConsumer<PsiElement>)((NullableConsumer)psiElement -> {
            if (psiElement instanceof PsiNamedElement && psiElement != element) {
                allRenames.put((PsiElement)psiElement, newName);
            }
        }));
    }

    static void visitReferencedElements(PsiReference[] references, NullableConsumer<PsiElement> consumer) {
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResults;
                for (ResolveResult resolveResult : resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    consumer.consume((Object)resolveResult.getElement());
                }
                continue;
            }
            consumer.consume((Object)reference.resolve());
        }
    }
}

